/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.messaging.dispatch.AsyncDispatch;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.DispatchFailureHandler;
import org.gradle.messaging.dispatch.QueuingDispatch;
import org.gradle.messaging.remote.internal.AsyncConnection;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.protocol.EndOfStreamEvent;
import org.gradle.messaging.remote.internal.protocol.RoutableMessage;
import org.gradle.messaging.remote.internal.protocol.RouteAvailableMessage;
import org.gradle.messaging.remote.internal.protocol.RouteUnavailableMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Router
implements Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Router.class);
    private final AsyncDispatch<Runnable> workQueue;
    private final Group localConnections = new LocalGroup();
    private final Group remoteConnections = new RemoteGroup();
    private final DispatchFailureHandler<? super Message> failureHandler;

    public Router(Executor executor, DispatchFailureHandler<? super Message> failureHandler) {
        this.failureHandler = failureHandler;
        this.localConnections.peer = this.remoteConnections;
        this.remoteConnections.peer = this.localConnections;
        this.workQueue = new AsyncDispatch(executor);
        this.workQueue.dispatchTo(new Dispatch<Runnable>(){

            @Override
            public void dispatch(Runnable message) {
                message.run();
            }
        });
    }

    public AsyncConnection<Message> createLocalConnection() {
        return new Endpoint(this.localConnections);
    }

    public AsyncConnection<Message> createRemoteConnection() {
        return new Endpoint(this.remoteConnections);
    }

    public void stop() {
        this.workQueue.stop();
    }

    private static class RemoteGroup
    extends Group {
        private RemoteGroup() {
        }

        public void addEndpoint(Endpoint endpoint) {
            super.addEndpoint(endpoint);
            for (Route route : this.peer.routes.values()) {
                endpoint.dispatchIncoming((Message)((Object)route.announcement));
            }
        }

        public void addRoute(Route route) {
            super.addRoute(route);
            for (Route targetRoute : this.peer.routes.values()) {
                if (!targetRoute.announcement.acceptIncoming(route.announcement)) continue;
                route.connectTo(targetRoute);
            }
        }

        public Route removeRoute(Object routeId) {
            Route route = super.removeRoute(routeId);
            for (Route target : route.targets) {
                Message unavailableMessage = (Message)((Object)route.announcement.getUnavailableMessage());
                target.destination.dispatchIncoming(unavailableMessage);
            }
            route.targets.clear();
            return route;
        }
    }

    private static class LocalGroup
    extends Group {
        private LocalGroup() {
        }

        public void addRoute(Route route) {
            super.addRoute(route);
            for (Endpoint endpoint : this.peer.endpoints) {
                endpoint.dispatchIncoming((Message)((Object)route.announcement));
            }
            for (Route targetRoute : this.peer.routes.values()) {
                if (!route.announcement.acceptIncoming(targetRoute.announcement)) continue;
                targetRoute.connectTo(route);
            }
        }

        public Route removeRoute(Object routeId) {
            Route route = super.removeRoute(routeId);
            Message unavailableMessage = (Message)((Object)route.announcement.getUnavailableMessage());
            for (Endpoint endpoint : this.peer.endpoints) {
                endpoint.dispatchIncoming(unavailableMessage);
            }
            for (Route targetRoute : this.peer.routes.values()) {
                targetRoute.targets.remove(route);
            }
            return route;
        }

        public void removeEndpoint(Endpoint endpoint) {
            super.removeEndpoint(endpoint);
            for (Route route : this.peer.routes.values()) {
                route.targets.removeAll(endpoint.routes);
            }
        }
    }

    private static class Group {
        private final Map<Object, Route> routes = new HashMap<Object, Route>();
        private final Set<Endpoint> endpoints = new HashSet<Endpoint>();
        Group peer;

        private Group() {
        }

        public void addEndpoint(Endpoint endpoint) {
            this.endpoints.add(endpoint);
        }

        public void addRoute(Route route) {
            this.routes.put(route.id, route);
        }

        public Route removeRoute(Object routeId) {
            return this.routes.remove(routeId);
        }

        public void send(Object routeId, Message message) {
            this.routes.get((Object)routeId).destination.dispatchIncoming(message);
        }

        public void removeEndpoint(Endpoint endpoint) {
            this.endpoints.remove(endpoint);
        }
    }

    private static class Route {
        final Object id;
        final RouteAvailableMessage announcement;
        final Endpoint destination;
        final Set<Route> targets = new HashSet<Route>();

        private Route(Object id, Endpoint destination, RouteAvailableMessage announcement) {
            this.id = id;
            this.destination = destination;
            this.announcement = announcement;
        }

        public void connectTo(Route target) {
            this.targets.add(target);
            target.destination.dispatchIncoming((Message)((Object)this.announcement));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Endpoint
    implements AsyncConnection<Message> {
        private QueuingDispatch<Message> handler = new QueuingDispatch();
        final Group owner;
        final Group peerGroup;
        final Set<Route> routes = new HashSet<Route>();

        protected Endpoint(Group owner) {
            this.owner = owner;
            this.peerGroup = owner.peer;
            owner.addEndpoint(this);
        }

        @Override
        public void dispatchTo(final Dispatch<? super Message> handler) {
            Router.this.workQueue.dispatch(new Runnable(){

                public void run() {
                    Endpoint.this.handler.dispatchTo(handler);
                }
            });
        }

        @Override
        public void dispatch(final Message message) {
            Router.this.workQueue.dispatch(new Runnable(){

                public void run() {
                    block7: {
                        try {
                            if (message instanceof RouteAvailableMessage) {
                                RouteAvailableMessage routeAvailableMessage = (RouteAvailableMessage)((Object)message);
                                LOGGER.debug("Received route available. Message: {}", (Object)routeAvailableMessage);
                                Route route = new Route(routeAvailableMessage.getId(), Endpoint.this, routeAvailableMessage);
                                Endpoint.this.routes.add(route);
                                Endpoint.this.owner.addRoute(route);
                                break block7;
                            }
                            if (message instanceof RouteUnavailableMessage) {
                                RouteUnavailableMessage routeUnavailableMessage = (RouteUnavailableMessage)((Object)message);
                                LOGGER.debug("Received route unavailable. Message: {}", (Object)routeUnavailableMessage);
                                Route route = Endpoint.this.owner.removeRoute(routeUnavailableMessage.getId());
                                Endpoint.this.routes.remove(route);
                                break block7;
                            }
                            if (message instanceof RoutableMessage) {
                                RoutableMessage routableMessage = (RoutableMessage)((Object)message);
                                Endpoint.this.peerGroup.send(routableMessage.getDestination(), message);
                                break block7;
                            }
                            if (message instanceof EndOfStreamEvent) {
                                for (Route route : Endpoint.this.routes) {
                                    LOGGER.debug("Removing route {} due to end of stream.", route.id);
                                    Endpoint.this.owner.removeRoute(route.id);
                                }
                                Endpoint.this.owner.removeEndpoint(Endpoint.this);
                                Endpoint.this.dispatchIncoming(message);
                                break block7;
                            }
                            throw new UnsupportedOperationException(String.format("Received message which cannot be routed: %s.", message));
                        }
                        catch (Throwable throwable) {
                            Router.this.failureHandler.dispatchFailed(message, throwable);
                        }
                    }
                }
            });
        }

        void dispatchIncoming(Message message) {
            this.handler.dispatch(message);
        }
    }
}

