/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.ExecutionEvent;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.instrument.Instrumenter;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.vm.ArgumentsMishmashException;
import com.oracle.truffle.api.vm.ComputeInExecutor;
import com.oracle.truffle.api.vm.EngineTruffleObject;
import com.oracle.truffle.api.vm.EventConsumer;
import com.oracle.truffle.api.vm.LanguageCache;
import com.oracle.truffle.api.vm.SymbolInvokerImpl;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PolyglotEngine {
    static final boolean JAVA_INTEROP_ENABLED = !TruffleOptions.AOT;
    static final Logger LOG = Logger.getLogger(PolyglotEngine.class.getName());
    private static final SPIAccessor SPI = new SPIAccessor();
    private final Thread initThread;
    private final Executor executor;
    private final Map<String, Language> langs;
    private final InputStream in;
    private final OutputStream err;
    private final OutputStream out;
    private final EventConsumer<?>[] handlers;
    private final Map<String, Object> globals;
    private final Instrumenter instrumenter;
    private final Debugger debugger;
    private boolean disposed;

    PolyglotEngine() {
        this.initThread = null;
        this.in = null;
        this.err = null;
        this.out = null;
        this.langs = null;
        this.handlers = null;
        this.globals = null;
        this.executor = null;
        this.instrumenter = null;
        this.debugger = null;
    }

    PolyglotEngine(Executor executor, Map<String, Object> globals, OutputStream out, OutputStream err, InputStream in, EventConsumer<?>[] handlers) {
        this.executor = executor;
        this.out = out;
        this.err = err;
        this.in = in;
        this.handlers = handlers;
        this.initThread = Thread.currentThread();
        this.globals = new HashMap<String, Object>(globals);
        this.instrumenter = SPI.createInstrumenter(this);
        this.debugger = SPI.createDebugger(this, this.instrumenter);
        HashMap<String, Language> map = new HashMap<String, Language>();
        HashSet<LanguageCache> uniqueCaches = new HashSet<LanguageCache>(LanguageCache.languages().values());
        for (LanguageCache languageCache : uniqueCaches) {
            Language newLanguage = new Language(languageCache);
            for (String mimeType : newLanguage.getMimeTypes()) {
                map.put(mimeType, newLanguage);
            }
        }
        this.langs = map;
    }

    public static Builder newBuilder() {
        PolyglotEngine vm = new PolyglotEngine();
        return vm.new Builder();
    }

    @Deprecated
    public static Builder buildNew() {
        return PolyglotEngine.newBuilder();
    }

    public Map<String, ? extends Language> getLanguages() {
        return Collections.unmodifiableMap(this.langs);
    }

    public Value eval(Source source) throws IOException {
        String mimeType = source.getMimeType();
        this.checkThread();
        Language l = this.langs.get(mimeType);
        if (l == null) {
            throw new IOException("No language for MIME type " + mimeType + " found. Supported types: " + this.langs.keySet());
        }
        return this.eval(l, source);
    }

    public void dispose() {
        this.checkThread();
        this.disposed = true;
        ComputeInExecutor<Void> compute = new ComputeInExecutor<Void>(this.executor){

            @Override
            protected Void compute() throws IOException {
                for (Language language : PolyglotEngine.this.getLanguages().values()) {
                    TruffleLanguage<?> impl = language.getImpl(false);
                    if (impl == null) continue;
                    try {
                        SPI.dispose(impl, language.getEnv(true));
                    }
                    catch (Error | Exception ex) {
                        LOG.log(Level.SEVERE, "Error disposing " + impl, ex);
                    }
                }
                return null;
            }
        };
        try {
            compute.perform();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Value eval(final Language l, final Source s) throws IOException {
        final TruffleLanguage[] lang = new TruffleLanguage[]{null};
        ComputeInExecutor<Object> compute = new ComputeInExecutor<Object>(this.executor){

            @Override
            protected Object compute() throws IOException {
                return PolyglotEngine.this.evalImpl(lang, s, l);
            }
        };
        compute.perform();
        return new Value(lang, compute);
    }

    Language createLanguage(Map.Entry<String, LanguageCache> en) {
        return new Language(en.getValue());
    }

    private Object evalImpl(TruffleLanguage<?>[] fillLang, Source s, Language l) throws IOException {
        try (Closeable d = SPI.executionStart(this, -1, this.debugger, s);){
            TruffleLanguage<?> langImpl = l.getImpl(true);
            fillLang[0] = langImpl;
            Object object = SPI.eval(langImpl, s, l.cache);
            return object;
        }
    }

    final Object invokeForeign(Node foreignNode, VirtualFrame frame, TruffleObject receiver) throws IOException {
        Object res;
        if (this.executor == null) {
            try (Closeable c = SPI.executionStart(this, -1, this.debugger, null);){
                Object[] args = ForeignAccess.getArguments(frame).toArray();
                res = ForeignAccess.execute(foreignNode, frame, receiver, args);
            }
        } else {
            res = this.invokeForeignOnExecutor(foreignNode, frame, receiver);
        }
        if (res instanceof TruffleObject) {
            return new EngineTruffleObject(this, (TruffleObject)res);
        }
        return res;
    }

    @CompilerDirectives.TruffleBoundary
    private Object invokeForeignOnExecutor(final Node foreignNode, VirtualFrame frame, final TruffleObject receiver) throws IOException {
        final MaterializedFrame materialized = frame.materialize();
        ComputeInExecutor<Object> compute = new ComputeInExecutor<Object>(this.executor){

            @Override
            protected Object compute() throws IOException {
                try (Closeable c = SPI.executionStart(PolyglotEngine.this, -1, PolyglotEngine.this.debugger, null);){
                    Object[] args = ForeignAccess.getArguments(materialized).toArray();
                    RootNode node = SymbolInvokerImpl.createTemporaryRoot(TruffleLanguage.class, foreignNode, receiver, args.length);
                    RootCallTarget target = Truffle.getRuntime().createCallTarget(node);
                    Object object = target.call(args);
                    return object;
                }
            }
        };
        return compute.get();
    }

    public Value findGlobalSymbol(final String globalName) {
        this.checkThread();
        final TruffleLanguage[] lang = new TruffleLanguage[]{null};
        ComputeInExecutor<Object> compute = new ComputeInExecutor<Object>(this.executor){

            @Override
            protected Object compute() throws IOException {
                TruffleLanguage.Env env;
                Object obj = PolyglotEngine.this.globals.get(globalName);
                if (obj == null) {
                    for (Language dl : PolyglotEngine.this.langs.values()) {
                        env = dl.getEnv(false);
                        if (env == null || (obj = SPI.findExportedSymbol(env, globalName, true)) == null) continue;
                        lang[0] = dl.getImpl(true);
                        break;
                    }
                }
                if (obj == null) {
                    for (Language dl : PolyglotEngine.this.langs.values()) {
                        env = dl.getEnv(false);
                        if (env == null || (obj = SPI.findExportedSymbol(env, globalName, true)) == null) continue;
                        lang[0] = dl.getImpl(true);
                        break;
                    }
                }
                return obj;
            }
        };
        try {
            compute.perform();
            if (compute.get() == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Value(lang, compute);
    }

    private void checkThread() {
        if (this.initThread != Thread.currentThread()) {
            throw new IllegalStateException("PolyglotEngine created on " + this.initThread.getName() + " but used on " + Thread.currentThread().getName());
        }
        if (this.disposed) {
            throw new IllegalStateException("Engine has already been disposed");
        }
    }

    void dispatch(Object ev) {
        Class<?> type = ev.getClass();
        if (type == SuspendedEvent.class) {
            this.dispatchSuspendedEvent((SuspendedEvent)ev);
        }
        if (type == ExecutionEvent.class) {
            this.dispatchExecutionEvent((ExecutionEvent)ev);
        }
        this.dispatch(type, ev);
    }

    void dispatchSuspendedEvent(SuspendedEvent event) {
    }

    void dispatchExecutionEvent(ExecutionEvent event) {
    }

    <Event> void dispatch(Class<Event> type, Event event) {
        for (EventConsumer<?> handler : this.handlers) {
            if (handler.type != type) continue;
            handler.on(event);
        }
    }

    TruffleLanguage<?> findLanguage(Class<? extends TruffleLanguage> languageClazz) {
        for (Map.Entry<String, Language> entrySet : this.langs.entrySet()) {
            Language languageDescription = entrySet.getValue();
            TruffleLanguage<?> impl = languageDescription.getImpl(false);
            if (!languageClazz.isInstance(impl)) continue;
            return impl;
        }
        return null;
    }

    TruffleLanguage<?> findLanguage(String mimeType) {
        Language languageDescription = this.langs.get(mimeType);
        if (languageDescription != null) {
            return languageDescription.getImpl(true);
        }
        return null;
    }

    TruffleLanguage<?> findLanguage(Probe probe) {
        return this.findLanguage(SPI.findLanguage(probe));
    }

    TruffleLanguage.Env findEnv(Class<? extends TruffleLanguage> languageClazz) {
        for (Map.Entry<String, Language> entrySet : this.langs.entrySet()) {
            Language languageDescription = entrySet.getValue();
            TruffleLanguage.Env env = languageDescription.getEnv(false);
            if (env == null || !languageClazz.isInstance(languageDescription.getImpl(false))) continue;
            return env;
        }
        throw new IllegalStateException("Cannot find language " + languageClazz + " among " + this.langs);
    }

    private static class SPIAccessor
    extends Accessor {
        private SPIAccessor() {
        }

        @Override
        public Object importSymbol(Object vmObj, TruffleLanguage<?> ownLang, String globalName) {
            Object obj;
            TruffleLanguage.Env env;
            TruffleLanguage<?> l;
            PolyglotEngine vm = (PolyglotEngine)vmObj;
            Object g = vm.globals.get(globalName);
            if (g != null) {
                return g;
            }
            LinkedHashSet uniqueLang = new LinkedHashSet(vm.langs.values());
            for (Language dl : uniqueLang) {
                l = dl.getImpl(false);
                env = dl.getEnv(false);
                if (l == ownLang || l == null || env == null || (obj = SPI.findExportedSymbol(env, globalName, true)) == null) continue;
                return obj;
            }
            for (Language dl : uniqueLang) {
                l = dl.getImpl(false);
                env = dl.getEnv(false);
                if (l == ownLang || l == null || env == null || (obj = SPI.findExportedSymbol(env, globalName, false)) == null) continue;
                return obj;
            }
            return null;
        }

        @Override
        protected TruffleLanguage.Env attachEnv(Object obj, TruffleLanguage<?> language, OutputStream stdOut, OutputStream stdErr, InputStream stdIn, Instrumenter instrumenter) {
            PolyglotEngine vm = (PolyglotEngine)obj;
            return super.attachEnv(vm, language, stdOut, stdErr, stdIn, instrumenter);
        }

        @Override
        protected Object eval(TruffleLanguage<?> l, Source s, Map<Source, CallTarget> cache) throws IOException {
            return super.eval(l, s, cache);
        }

        @Override
        public Object findExportedSymbol(TruffleLanguage.Env env, String globalName, boolean onlyExplicit) {
            return super.findExportedSymbol(env, globalName, onlyExplicit);
        }

        @Override
        protected Object languageGlobal(TruffleLanguage.Env env) {
            return super.languageGlobal(env);
        }

        @Override
        protected Instrumenter createInstrumenter(Object vm) {
            return super.createInstrumenter(vm);
        }

        @Override
        protected Debugger createDebugger(Object vm, Instrumenter instrumenter) {
            return super.createDebugger(vm, instrumenter);
        }

        @Override
        protected Instrumenter getInstrumenter(Object obj) {
            PolyglotEngine vm = (PolyglotEngine)obj;
            return vm.instrumenter;
        }

        @Override
        protected Class<? extends TruffleLanguage> findLanguage(Probe probe) {
            return super.findLanguage(probe);
        }

        @Override
        protected TruffleLanguage.Env findLanguage(Object obj, Class<? extends TruffleLanguage> languageClass) {
            PolyglotEngine vm = (PolyglotEngine)obj;
            return vm.findEnv(languageClass);
        }

        @Override
        protected TruffleLanguage<?> findLanguageImpl(Object obj, Class<? extends TruffleLanguage> languageClazz, String mimeType) {
            PolyglotEngine vm = (PolyglotEngine)obj;
            TruffleLanguage<?> language = null;
            if (languageClazz != null) {
                language = vm.findLanguage(languageClazz);
            }
            if (language == null && mimeType != null) {
                language = vm.findLanguage(mimeType);
            }
            if (language == null) {
                throw new IllegalStateException("Cannot find language " + languageClazz + " with mimeType" + mimeType + " among " + vm.langs);
            }
            return language;
        }

        @Override
        protected Closeable executionStart(Object obj, int currentDepth, Debugger debugger, Source s) {
            PolyglotEngine vm = (PolyglotEngine)obj;
            return super.executionStart(vm, -1, debugger, s);
        }

        @Override
        protected void dispatchEvent(Object obj, Object event) {
            PolyglotEngine vm = (PolyglotEngine)obj;
            vm.dispatch(event);
        }

        @Override
        protected void dispose(TruffleLanguage<?> impl, TruffleLanguage.Env env) {
            super.dispose(impl, env);
        }

        protected String toString(TruffleLanguage language, TruffleLanguage.Env env, Object obj) {
            return super.toString(language, env, obj);
        }
    }

    public class Language {
        private final Map<Source, CallTarget> cache = new WeakHashMap<Source, CallTarget>();
        private final LanguageCache info;
        private TruffleLanguage.Env env;

        Language(LanguageCache info) {
            this.info = info;
        }

        public Set<String> getMimeTypes() {
            return this.info.getMimeTypes();
        }

        public String getName() {
            return this.info.getName();
        }

        public String getVersion() {
            return this.info.getVersion();
        }

        public Value eval(Source source) throws IOException {
            PolyglotEngine.this.checkThread();
            return PolyglotEngine.this.eval(this, source);
        }

        public Value getGlobalObject() {
            PolyglotEngine.this.checkThread();
            Object res = SPI.languageGlobal(this.getEnv(true));
            return res == null ? null : new Value(new TruffleLanguage[]{this.info.getImpl(true)}, res);
        }

        TruffleLanguage<?> getImpl(boolean create) {
            this.getEnv(create);
            TruffleLanguage<?> impl = this.info.getImpl(false);
            return impl;
        }

        TruffleLanguage.Env getEnv(boolean create) {
            if (this.env == null && create) {
                this.env = SPI.attachEnv(PolyglotEngine.this, this.info.getImpl(true), PolyglotEngine.this.out, PolyglotEngine.this.err, PolyglotEngine.this.in, PolyglotEngine.this.instrumenter);
            }
            return this.env;
        }

        public String toString() {
            return "[" + this.getName() + "@ " + this.getVersion() + " for " + this.getMimeTypes() + "]";
        }
    }

    public class Value {
        private final TruffleLanguage<?>[] language;
        private final ComputeInExecutor<Object> compute;
        private CallTarget target;

        Value(TruffleLanguage<?>[] language, ComputeInExecutor<Object> compute) {
            this.language = language;
            this.compute = compute;
        }

        Value(TruffleLanguage<?>[] language, final Object value) {
            this.language = language;
            this.compute = new ComputeInExecutor<Object>(null){

                @Override
                protected Object compute() throws IOException {
                    return value;
                }
            };
        }

        public Object get() throws IOException {
            Object result = this.waitForSymbol();
            if (result instanceof TruffleObject) {
                return new EngineTruffleObject(PolyglotEngine.this, (TruffleObject)result);
            }
            return result;
        }

        public <T> T as(Class<T> representation) throws IOException {
            EngineTruffleObject eto;
            Object obj = this.get();
            if (obj instanceof EngineTruffleObject && representation.isInstance((eto = (EngineTruffleObject)obj).getDelegate())) {
                return representation.cast(eto.getDelegate());
            }
            if (representation == String.class) {
                Class<?> clazz = this.language[0].getClass();
                Object unwrapped = obj;
                while (unwrapped instanceof EngineTruffleObject) {
                    unwrapped = ((EngineTruffleObject)obj).getDelegate();
                }
                return representation.cast(SPI.toString((TruffleLanguage)this.language[0], PolyglotEngine.this.findEnv(clazz), unwrapped));
            }
            if (representation.isInstance(obj)) {
                return representation.cast(obj);
            }
            if (JAVA_INTEROP_ENABLED) {
                return JavaInterop.asJavaObject(representation, (TruffleObject)obj);
            }
            throw new ClassCastException("Value cannot be represented as " + representation.getName());
        }

        @Deprecated
        public Value invoke(Object thiz, Object ... args) throws IOException {
            return this.execute(args);
        }

        public Value execute(final Object ... args) throws IOException {
            this.get();
            ComputeInExecutor<Object> invokeCompute = new ComputeInExecutor<Object>(PolyglotEngine.this.executor){

                @Override
                protected Object compute() throws IOException {
                    Throwable throwable = null;
                    try (Closeable c = SPI.executionStart(PolyglotEngine.this, -1, PolyglotEngine.this.debugger, null);){
                        ArrayList<Object> arr = new ArrayList<Object>();
                        arr.addAll(Arrays.asList(args));
                        while (true) {
                            try {
                                if (Value.this.target == null) {
                                    Value.this.target = SymbolInvokerImpl.createCallTarget(Value.this.language[0], Value.this.compute.get(), arr.toArray());
                                }
                                Object object = Value.this.target.call(arr.toArray());
                                return object;
                            }
                            catch (ArgumentsMishmashException ex) {
                                try {
                                    Value.this.target = null;
                                    continue;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                            }
                            break;
                        }
                    }
                }
            };
            invokeCompute.perform();
            return new Value(this.language, invokeCompute);
        }

        private Object waitForSymbol() throws IOException {
            PolyglotEngine.this.checkThread();
            return this.compute.get();
        }

        public String toString() {
            return "PolyglotEngine.Value[" + this.compute + "]";
        }
    }

    public class Builder {
        private OutputStream out;
        private OutputStream err;
        private InputStream in;
        private final List<EventConsumer<?>> handlers = new ArrayList();
        private final Map<String, Object> globals = new HashMap<String, Object>();
        private Executor executor;

        Builder() {
        }

        public Builder setOut(OutputStream os) {
            this.out = os;
            return this;
        }

        public Builder setErr(OutputStream os) {
            this.err = os;
            return this;
        }

        public Builder setIn(InputStream is) {
            this.in = is;
            return this;
        }

        public Builder onEvent(EventConsumer<?> handler) {
            handler.getClass();
            this.handlers.add(handler);
            return this;
        }

        public Builder globalSymbol(String name, Object obj) {
            Object truffleReady;
            if (obj instanceof TruffleObject || obj instanceof Number || obj instanceof String || obj instanceof Character || obj instanceof Boolean) {
                truffleReady = obj;
            } else if (JAVA_INTEROP_ENABLED) {
                truffleReady = JavaInterop.asTruffleObject(obj);
            } else {
                throw new IllegalArgumentException();
            }
            this.globals.put(name, truffleReady);
            return this;
        }

        public Builder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public PolyglotEngine build() {
            if (this.out == null) {
                this.out = System.out;
            }
            if (this.err == null) {
                this.err = System.err;
            }
            if (this.in == null) {
                this.in = System.in;
            }
            return new PolyglotEngine(this.executor, this.globals, this.out, this.err, this.in, this.handlers.toArray(new EventConsumer[0]));
        }
    }
}

