// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var E, GE, ST, TrackSubSubCommand, TrackWrapper, User, assertion, athrow, chain_err, colors, constants, db, deq, env, iced, keypull, log, make_esc, master_ring, prompt_yn, proof_type_to_string, proofs, session, tor, unix_time, util, __iced_k, __iced_k_noop, _ref, _ref1, _ref2;

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  db = require('./db').db;

  constants = require('./constants').constants;

  log = require('./log');

  proofs = require('keybase-proofs');

  proof_type_to_string = proofs.proof_type_to_string;

  ST = constants.signature_types;

  deq = require('deep-equal');

  _ref = require('./err'), GE = _ref.GE, E = _ref.E;

  _ref1 = require('pgp-utils').util, athrow = _ref1.athrow, unix_time = _ref1.unix_time;

  _ref2 = require('iced-error'), chain_err = _ref2.chain_err, make_esc = _ref2.make_esc;

  prompt_yn = require('./prompter').prompt_yn;

  session = require('./session').session;

  User = require('./user').User;

  db = require('./db');

  util = require('util');

  env = require('./env').env;

  TrackWrapper = require('./trackwrapper').TrackWrapper;

  master_ring = require('./keyring').master_ring;

  assertion = require('libkeybase').assertion;

  keypull = require('./keypull').keypull;

  colors = require('./colors');

  tor = require('./tor');

  exports.TrackSubSubCommand = TrackSubSubCommand = (function() {
    TrackSubSubCommand.OPTS = {
      r: {
        alias: "track-remote",
        action: "storeTrue",
        help: "remotely track by default"
      },
      l: {
        alias: "track-local",
        action: "storeTrue",
        help: "don't prompt for remote tracking"
      },
      a: {
        alias: "assert",
        help: "provide an identity assertion"
      },
      batch: {
        action: 'storeTrue',
        help: "batch-mode without interactivity"
      },
      "prompt-remote": {
        action: 'storeTrue',
        help: "prompt for remote tracking"
      }
    };

    function TrackSubSubCommand(_arg) {
      this.args = _arg.args, this.opts = _arg.opts, this.tmp_keyring = _arg.tmp_keyring, this.batch = _arg.batch, this.track_local = _arg.track_local, this.ran_keypull = _arg.ran_keypull, this.assertions = _arg.assertions;
      this.opts || (this.opts = {});
    }

    TrackSubSubCommand.prototype.is_batch = function() {
      return this.opts.batch || this.batch;
    };

    TrackSubSubCommand.prototype.prompt_ok = function(warnings, proofs, cb) {
      var err, prompt, ret, them, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      them = this.args.them;
      prompt = warnings ? (log.console.error(colors.red("Some remote proofs failed!")), "Still verify this user as " + them + "?") : proofs === 0 ? "We found an account for " + them + ", but they haven't proved their identity. Still accept them?" : "Is this the " + them + " you wanted?";
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/tracksubsub.iced",
            funcname: "TrackSubSubCommand.prompt_ok"
          });
          prompt_yn({
            prompt: prompt,
            defval: false
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return ret = arguments[1];
              };
            })(),
            lineno: 67
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, ret);
        };
      })(this));
    };

    TrackSubSubCommand.prototype.prompt_track = function(proofs, cb) {
      var err, prompt, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      ret = err = null;
      (function(_this) {
        return (function(__iced_k) {
          if (_this.opts.track_remote) {
            return __iced_k(ret = true);
          } else {
            (function(__iced_k) {
              if (_this.is_batch()) {
                return __iced_k(ret = false);
              } else {
                (function(__iced_k) {
                  if (!_this.me.have_secret_key()) {
                    return __iced_k(ret = false);
                  } else {
                    (function(__iced_k) {
                      if ((_this.opts.track_local || _this.track_local) && !_this.opts.prompt_remote) {
                        return __iced_k(ret = false);
                      } else {
                        prompt = "Permanently track this user, and write proof to server?";
                        (function(__iced_k) {
                          __iced_deferrals = new iced.Deferrals(__iced_k, {
                            parent: ___iced_passed_deferral,
                            filename: "/home/jacko/node-client/src/tracksubsub.iced",
                            funcname: "TrackSubSubCommand.prompt_track"
                          });
                          prompt_yn({
                            prompt: prompt,
                            defval: true
                          }, __iced_deferrals.defer({
                            assign_fn: (function() {
                              return function() {
                                err = arguments[0];
                                return ret = arguments[1];
                              };
                            })(),
                            lineno: 84
                          }));
                          __iced_deferrals._fulfill();
                        })(__iced_k);
                      }
                    })(__iced_k);
                  }
                })(__iced_k);
              }
            })(__iced_k);
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, ret);
        };
      })(this));
    };

    TrackSubSubCommand.prototype.on_loggedout_verify = function(cb) {
      var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "TrackSubSub::on_loggedout_verify");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/tracksubsub.iced",
            funcname: "TrackSubSubCommand.on_loggedout_verify"
          });
          User.load({
            username: _this.args.them
          }, esc(__iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                return __slot_1.them = arguments[0];
              };
            })(_this),
            lineno: 91
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(null);
        };
      })(this));
    };

    TrackSubSubCommand.prototype.on_decrypt = function(cb) {
      var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "TrackSubSub::on_decrypt");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/tracksubsub.iced",
            funcname: "TrackSubSubCommand.on_decrypt"
          });
          _this.keypull(esc(__iced_deferrals.defer({
            lineno: 98
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/jacko/node-client/src/tracksubsub.iced",
              funcname: "TrackSubSubCommand.on_decrypt"
            });
            User.load({
              username: _this.args.them
            }, esc(__iced_deferrals.defer({
              assign_fn: (function(__slot_1) {
                return function() {
                  return __slot_1.them = arguments[0];
                };
              })(_this),
              lineno: 99
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/node-client/src/tracksubsub.iced",
                funcname: "TrackSubSubCommand.on_decrypt"
              });
              User.load_me({
                maybe_secret: true
              }, esc(__iced_deferrals.defer({
                assign_fn: (function(__slot_1) {
                  return function() {
                    return __slot_1.me = arguments[0];
                  };
                })(_this),
                lineno: 100
              })));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/node-client/src/tracksubsub.iced",
                  funcname: "TrackSubSubCommand.on_decrypt"
                });
                _this.check_not_self(esc(__iced_deferrals.defer({
                  lineno: 101
                })));
                __iced_deferrals._fulfill();
              })(function() {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/jacko/node-client/src/tracksubsub.iced",
                    funcname: "TrackSubSubCommand.on_decrypt"
                  });
                  TrackWrapper.load({
                    tracker: _this.me,
                    trackee: _this.them
                  }, esc(__iced_deferrals.defer({
                    assign_fn: (function(__slot_1) {
                      return function() {
                        return __slot_1.trackw = arguments[0];
                      };
                    })(_this),
                    lineno: 102
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  return cb(null);
                });
              });
            });
          });
        };
      })(this));
    };

    TrackSubSubCommand.prototype.check_remote_proofs = function(skip, cb) {
      var err, esc, n_proofs, opts, warnings, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "TrackSubSub::check_remote_proofs");
      log.debug("+ TrackSubSub::check_remote_proofs");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/tracksubsub.iced",
            funcname: "TrackSubSubCommand.check_remote_proofs"
          });
          _this.parse_assertions(esc(__iced_deferrals.defer({
            lineno: 110
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          opts = {
            skip: skip,
            assertions: _this.assertions
          };
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/jacko/node-client/src/tracksubsub.iced",
              funcname: "TrackSubSubCommand.check_remote_proofs"
            });
            _this.them.check_remote_proofs(opts, esc(__iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  warnings = arguments[0];
                  return n_proofs = arguments[1];
                };
              })(),
              lineno: 112
            })));
            __iced_deferrals._fulfill();
          })(function() {
            err = null;
            log.debug("- TrackSubSub::check_remote_proofs -> " + (err != null ? err.message : void 0));
            return cb(err, warnings, n_proofs);
          });
        };
      })(this));
    };

    TrackSubSubCommand.prototype.resolve_them = function(cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/tracksubsub.iced",
            funcname: "TrackSubSubCommand.resolve_them"
          });
          User.resolve_user_name({
            username: _this.args.them
          }, __iced_deferrals.defer({
            assign_fn: (function(__slot_1, __slot_2) {
              return function() {
                err = arguments[0];
                __slot_1.them = arguments[1];
                return __slot_2.assertion = arguments[2];
              };
            })(_this.args, _this),
            lineno: 120
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    TrackSubSubCommand.prototype.id = function(cb) {
      var accept, esc, warnings, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "TrackSubSub:id");
      log.debug("+ id");
      accept = false;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/tracksubsub.iced",
            funcname: "TrackSubSubCommand.id"
          });
          _this.resolve_them(esc(__iced_deferrals.defer({
            lineno: 129
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/jacko/node-client/src/tracksubsub.iced",
              funcname: "TrackSubSubCommand.id"
            });
            User.load({
              username: _this.args.them,
              require_public_key: true
            }, esc(__iced_deferrals.defer({
              assign_fn: (function(__slot_1) {
                return function() {
                  return __slot_1.them = arguments[0];
                };
              })(_this),
              lineno: 130
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/node-client/src/tracksubsub.iced",
                funcname: "TrackSubSubCommand.id"
              });
              _this.check_remote_proofs(false, esc(__iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return warnings = arguments[0];
                  };
                })(),
                lineno: 131
              })));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/node-client/src/tracksubsub.iced",
                  funcname: "TrackSubSubCommand.id"
                });
                _this.them.display_cryptocurrency_addresses({}, esc(__iced_deferrals.defer({
                  lineno: 132
                })));
                __iced_deferrals._fulfill();
              })(function() {
                log.debug("- id");
                return cb(null);
              });
            });
          });
        };
      })(this));
    };

    TrackSubSubCommand.prototype.pre_encrypt = function(cb) {
      var err, logged_in, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          if (!env().is_configured()) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/node-client/src/tracksubsub.iced",
                funcname: "TrackSubSubCommand.pre_encrypt"
              });
              _this.id(__iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return err = arguments[0];
                  };
                })(),
                lineno: 140
              }));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/node-client/src/tracksubsub.iced",
                funcname: "TrackSubSubCommand.pre_encrypt"
              });
              session.load_and_check(__iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return logged_in = arguments[1];
                  };
                })(),
                lineno: 142
              }));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                if (err == null) {
                  _this.skip_keypull = !logged_in;
                  _this.track_local = !logged_in;
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/jacko/node-client/src/tracksubsub.iced",
                      funcname: "TrackSubSubCommand.pre_encrypt"
                    });
                    _this.run(__iced_deferrals.defer({
                      assign_fn: (function() {
                        return function() {
                          return err = arguments[0];
                        };
                      })(),
                      lineno: 146
                    }));
                    __iced_deferrals._fulfill();
                  })(__iced_k);
                } else {
                  return __iced_k();
                }
              })(__iced_k);
            });
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    TrackSubSubCommand.prototype.parse_assertions = function(cb) {
      var a, ca, e, err;
      err = null;
      ca = null;
      try {
        if ((a = this.opts.assert) != null) {
          ca = assertion.parse(a);
        }
      } catch (_error) {
        e = _error;
        err = new E.ParseAssertionError("Error parsing assertion '" + a + "': " + e.message);
      }
      if ((this.assertions != null) && (ca != null)) {
        this.assertions = new assertion.AND(this.assertions, ca);
      } else if (ca != null) {
        this.assertions = ca;
      }
      return cb(err);
    };

    TrackSubSubCommand.prototype.check_not_self = function(cb) {
      var err, t;
      err = null;
      if ((((t = this.args.them) != null) && (t === this.me.username())) || (((t = this.args.them_ki64) != null) && (t === this.me.key_id_64()))) {
        err = new E.SelfError("Cannot track yourself");
      }
      return cb(err);
    };

    TrackSubSubCommand.prototype.keypull = function(cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          if (!_this.ran_keypull && !_this.skip_keypull && !tor.enabled()) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/node-client/src/tracksubsub.iced",
                funcname: "TrackSubSubCommand.keypull"
              });
              keypull({
                need_secret: false,
                stdin_blocked: _this.is_batch()
              }, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return err = arguments[0];
                  };
                })(),
                lineno: 182
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(_this.ran_keypull = true);
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    TrackSubSubCommand.prototype.save_their_keys = function(cb) {
      var esc, key, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "TrackSubSub::save_their_keys");
      (function(_this) {
        return (function(__iced_k) {
          var _i, _len, _ref3, _results, _while;
          _ref3 = _this.them.gpg_keys;
          _len = _ref3.length;
          _i = 0;
          _results = [];
          _while = function(__iced_k) {
            var _break, _continue, _next;
            _break = function() {
              return __iced_k(_results);
            };
            _continue = function() {
              return iced.trampoline(function() {
                ++_i;
                return _while(__iced_k);
              });
            };
            _next = function(__iced_next_arg) {
              _results.push(__iced_next_arg);
              return _continue();
            };
            if (!(_i < _len)) {
              return _break();
            } else {
              key = _ref3[_i];
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/node-client/src/tracksubsub.iced",
                  funcname: "TrackSubSubCommand.save_their_keys"
                });
                key.copy_to_keyring(master_ring()).save(esc(__iced_deferrals.defer({
                  lineno: 191
                })));
                __iced_deferrals._fulfill();
              })(_next);
            }
          };
          _while(__iced_k);
        });
      })(this)((function(_this) {
        return function() {
          return cb(null);
        };
      })(this));
    };

    TrackSubSubCommand.prototype.run = function(cb) {
      var accept, ckres, esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "TrackSubSub::run");
      log.debug("+ run");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/tracksubsub.iced",
            funcname: "TrackSubSubCommand.run"
          });
          _this.keypull(esc(__iced_deferrals.defer({
            lineno: 202
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/jacko/node-client/src/tracksubsub.iced",
              funcname: "TrackSubSubCommand.run"
            });
            User.load_me({
              maybe_secret: true
            }, esc(__iced_deferrals.defer({
              assign_fn: (function(__slot_1) {
                return function() {
                  return __slot_1.me = arguments[0];
                };
              })(_this),
              lineno: 204
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/node-client/src/tracksubsub.iced",
                funcname: "TrackSubSubCommand.run"
              });
              _this.check_not_self(esc(__iced_deferrals.defer({
                lineno: 205
              })));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/node-client/src/tracksubsub.iced",
                  funcname: "TrackSubSubCommand.run"
                });
                _this.resolve_them(esc(__iced_deferrals.defer({
                  lineno: 207
                })));
                __iced_deferrals._fulfill();
              })(function() {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/jacko/node-client/src/tracksubsub.iced",
                    funcname: "TrackSubSubCommand.run"
                  });
                  User.load({
                    username: _this.args.them,
                    ki64: _this.args.them_ki64,
                    require_public_key: true
                  }, esc(__iced_deferrals.defer({
                    assign_fn: (function(__slot_1) {
                      return function() {
                        return __slot_1.them = arguments[0];
                      };
                    })(_this),
                    lineno: 208
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/jacko/node-client/src/tracksubsub.iced",
                      funcname: "TrackSubSubCommand.run"
                    });
                    TrackWrapper.load({
                      tracker: _this.me,
                      trackee: _this.them
                    }, esc(__iced_deferrals.defer({
                      assign_fn: (function(__slot_1) {
                        return function() {
                          return __slot_1.trackw = arguments[0];
                        };
                      })(_this),
                      lineno: 210
                    })));
                    __iced_deferrals._fulfill();
                  })(function() {
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/home/jacko/node-client/src/tracksubsub.iced",
                        funcname: "TrackSubSubCommand.run"
                      });
                      _this.all_prompts(esc(__iced_deferrals.defer({
                        assign_fn: (function() {
                          return function() {
                            return accept = arguments[0];
                          };
                        })(),
                        lineno: 211
                      })));
                      __iced_deferrals._fulfill();
                    })(function() {
                      (function(__iced_k) {
                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                          parent: ___iced_passed_deferral,
                          filename: "/home/jacko/node-client/src/tracksubsub.iced",
                          funcname: "TrackSubSubCommand.run"
                        });
                        _this.them.check_key({
                          secret: false,
                          store: true
                        }, esc(__iced_deferrals.defer({
                          assign_fn: (function() {
                            return function() {
                              return ckres = arguments[0];
                            };
                          })(),
                          lineno: 215
                        })));
                        __iced_deferrals._fulfill();
                      })(function() {
                        (function(__iced_k) {
                          if (accept && !ckres.local) {
                            (function(__iced_k) {
                              __iced_deferrals = new iced.Deferrals(__iced_k, {
                                parent: ___iced_passed_deferral,
                                filename: "/home/jacko/node-client/src/tracksubsub.iced",
                                funcname: "TrackSubSubCommand.run"
                              });
                              _this.save_their_keys(esc(__iced_deferrals.defer({
                                lineno: 217
                              })));
                              __iced_deferrals._fulfill();
                            })(__iced_k);
                          } else {
                            return __iced_k();
                          }
                        })(function() {
                          log.debug("- run");
                          return cb(null);
                        });
                      });
                    });
                  });
                });
              });
            });
          });
        };
      })(this));
    };

    TrackSubSubCommand.prototype.all_prompts = function(cb) {
      var accept, approve, check, do_remote, err, esc, n_proofs, n_warnings, skp, warnings, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "TrackSubSub::all_prompts");
      log.debug("+ TrackSubSub::all_prompts");
      check = this.trackw.skip_remote_check();
      if (check === constants.skip.NONE) {
        log.info("...checking identity proofs");
        skp = false;
      } else {
        log.info("...all remote checks are up-to-date");
        skp = true;
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/tracksubsub.iced",
            funcname: "TrackSubSubCommand.all_prompts"
          });
          _this.check_remote_proofs(skp, esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                warnings = arguments[0];
                return n_proofs = arguments[1];
              };
            })(),
            lineno: 236
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          n_warnings = warnings.warnings().length;
          (function(__iced_k) {
            if ((approve = _this.trackw.skip_approval()) !== constants.skip.NONE) {
              log.debug("| skipping approval, since remote services & key are unchanged");
              return __iced_k(accept = true);
            } else {
              (function(__iced_k) {
                if (_this.assertions != null) {
                  log.info("Identity accepted due to clean and complete assertions");
                  log.debug("| We can approve due to clean assertions");
                  return __iced_k(accept = true);
                } else {
                  (function(__iced_k) {
                    if (_this.is_batch()) {
                      log.warn("Interactive approval is needed");
                      log.debug("| We needed approval, but we were in batch mode");
                      return __iced_k(accept = false);
                    } else {
                      (function(__iced_k) {
                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                          parent: ___iced_passed_deferral,
                          filename: "/home/jacko/node-client/src/tracksubsub.iced",
                          funcname: "TrackSubSubCommand.all_prompts"
                        });
                        _this.prompt_ok(n_warnings, n_proofs, esc(__iced_deferrals.defer({
                          assign_fn: (function() {
                            return function() {
                              return accept = arguments[0];
                            };
                          })(),
                          lineno: 251
                        })));
                        __iced_deferrals._fulfill();
                      })(__iced_k);
                    }
                  })(__iced_k);
                }
              })(__iced_k);
            }
          })(function() {
            err = null;
            (function(__iced_k) {
              if (!accept) {
                log.warn("Bailing out; proofs were not accepted");
                return __iced_k(err = new E.CancelError("operation was canceled"));
              } else {
                (function(__iced_k) {
                  if ((check === constants.skip.REMOTE) && (approve === constants.skip.REMOTE)) {
                    return __iced_k(log.info("Nothing to do; tracking is up-to-date"));
                  } else {
                    (function(__iced_k) {
                      if (approve === constants.skip.REMOTE) {
                        return __iced_k(do_remote = false);
                      } else {
                        (function(__iced_k) {
                          if (tor.strict()) {
                            return __iced_k(log.warn("Can't write tracking statement to server in strict Tor mode"));
                          } else {
                            (function(__iced_k) {
                              __iced_deferrals = new iced.Deferrals(__iced_k, {
                                parent: ___iced_passed_deferral,
                                filename: "/home/jacko/node-client/src/tracksubsub.iced",
                                funcname: "TrackSubSubCommand.all_prompts"
                              });
                              _this.prompt_track(n_proofs, esc(__iced_deferrals.defer({
                                assign_fn: (function() {
                                  return function() {
                                    return do_remote = arguments[0];
                                  };
                                })(),
                                lineno: 265
                              })));
                              __iced_deferrals._fulfill();
                            })(function() {
                              (function(__iced_k) {
                                if (do_remote) {
                                  (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                      parent: ___iced_passed_deferral,
                                      filename: "/home/jacko/node-client/src/tracksubsub.iced",
                                      funcname: "TrackSubSubCommand.all_prompts"
                                    });
                                    session.load_and_login(esc(__iced_deferrals.defer({
                                      lineno: 267
                                    })));
                                    __iced_deferrals._fulfill();
                                  })(__iced_k);
                                } else {
                                  return __iced_k();
                                }
                              })(__iced_k);
                            });
                          }
                        })(__iced_k);
                      }
                    })(function() {
                      (function(__iced_k) {
                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                          parent: ___iced_passed_deferral,
                          filename: "/home/jacko/node-client/src/tracksubsub.iced",
                          funcname: "TrackSubSubCommand.all_prompts"
                        });
                        _this.trackw.store_track({
                          do_remote: do_remote
                        }, esc(__iced_deferrals.defer({
                          lineno: 268
                        })));
                        __iced_deferrals._fulfill();
                      })(__iced_k);
                    });
                  }
                })(__iced_k);
              }
            })(function() {
              log.debug("- TrackSubSub::all_prompts");
              return cb(err, accept);
            });
          });
        };
      })(this));
    };

    return TrackSubSubCommand;

  })();

}).call(this);
