// Generated by IcedCoffeeScript 1.8.0-d
(function() {
  var Base, Sodium, bufeq_secure,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  bufeq_secure = require('./util').bufeq_secure;

  Base = require('./base').Base;

  exports.Sodium = Sodium = (function(_super) {
    __extends(Sodium, _super);

    function Sodium() {
      return Sodium.__super__.constructor.apply(this, arguments);
    }

    Sodium.prototype._detach = function(sig) {
      var l;
      l = this.lib.c.crypto_sign_BYTES;
      return {
        sig: sig.slice(0, l),
        payload: sig.slice(l)
      };
    };

    Sodium.prototype.verify = function(_arg) {
      var detached, err, msg, payload, r_payload, sig;
      payload = _arg.payload, sig = _arg.sig, detached = _arg.detached;
      if (detached && (payload == null)) {
        err = new Error("in detached mode, you must supply a payload");
        return [err, null];
      }
      msg = detached ? Buffer.concat([sig, payload]) : sig;
      r_payload = this.lib.c.crypto_sign_open(msg, this.publicKey);
      if (r_payload == null) {
        err = new Error("Signature failed to verify");
      } else if (detached) {

      } else if (payload == null) {
        payload = r_payload;
      } else if (!bufeq_secure(r_payload, payload)) {
        err = new Error("got unexpected payload");
      }
      if (err != null) {
        payload = null;
      }
      return [err, payload];
    };

    Sodium.prototype.sign = function(_arg) {
      var detached, payload, sig;
      detached = _arg.detached, payload = _arg.payload;
      sig = this.lib.c.crypto_sign(payload, this.secretKey);
      if (detached) {
        return this._detach(sig).sig;
      } else {
        return sig;
      }
    };

    return Sodium;

  })(Base);

}).call(this);
