// Generated by IcedCoffeeScript 1.8.0-d
(function() {
  var BaseScraper, GenericWebSiteScraper, constants, iced, urlmod, v_codes, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime');
  __iced_k = __iced_k_noop = function() {};

  BaseScraper = require('./base').BaseScraper;

  constants = require('../constants').constants;

  v_codes = constants.v_codes;

  urlmod = require('url');

  exports.GenericWebSiteScraper = GenericWebSiteScraper = (function(_super) {
    __extends(GenericWebSiteScraper, _super);

    GenericWebSiteScraper.FILES = [".well-known/keybase.txt", "keybase.txt"];

    GenericWebSiteScraper.prototype.FILES = GenericWebSiteScraper.FILES;

    function GenericWebSiteScraper(opts) {
      GenericWebSiteScraper.__super__.constructor.call(this, opts);
    }

    GenericWebSiteScraper.prototype._check_args = function(args) {
      var _ref;
      if (!(args.hostname != null)) {
        return new Error("Bad args to generic website proof: no hostname given");
      } else if (!(args.protocol != null)) {
        return new Error("Not protocol given");
      } else if (!((_ref = args.protocol) === 'https:' || _ref === 'http:')) {
        return new Error("Unknown protocol given: " + args.protocol);
      } else {
        return null;
      }
    };

    GenericWebSiteScraper.prototype.get_tor_error = function(args) {
      if (args.protocol === 'http:') {
        return [new Error("HTTP (without TLS) isn't reliable over tor"), v_codes.TOR_SKIPPED];
      } else {
        return [null, v_codes.OK];
      }
    };

    GenericWebSiteScraper.prototype.make_url = function(_arg) {
      var hostname, pathname, protocol;
      protocol = _arg.protocol, hostname = _arg.hostname, pathname = _arg.pathname;
      return urlmod.format({
        hostname: hostname,
        protocol: protocol,
        pathname: pathname
      });
    };

    GenericWebSiteScraper.prototype._check_url = function(_arg, cb) {
      var err, proof_text_check, raw, rc, url, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      url = _arg.url, proof_text_check = _arg.proof_text_check;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/keybase-proofs/src/scrapers/generic_web_site.iced",
            funcname: "GenericWebSiteScraper._check_url"
          });
          _this._get_url_body({
            url: url
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                rc = arguments[1];
                return raw = arguments[2];
              };
            })(),
            lineno: 48
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          rc = rc !== v_codes.OK ? rc : _this._find_sig_in_raw(proof_text_check, raw) ? v_codes.OK : v_codes.NOT_FOUND;
          return cb(err, rc);
        };
      })(this));
    };

    GenericWebSiteScraper.prototype.hunt2 = function(_arg, cb) {
      var err, f, hostname, out, proof_text_check, protocol, rc, url, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      hostname = _arg.hostname, protocol = _arg.protocol, proof_text_check = _arg.proof_text_check;
      err = null;
      out = {};
      err = null;
      rc = v_codes.OK;
      (function(_this) {
        return (function(__iced_k) {
          if ((hostname == null) || (protocol == null)) {
            return __iced_k(err = new Error("invalid arguments: expected a hostname and protocol"));
          } else {
            (function(__iced_k) {
              var _i, _len, _ref, _results, _while;
              _ref = _this.FILES;
              _len = _ref.length;
              _i = 0;
              _results = [];
              _while = function(__iced_k) {
                var _break, _continue, _next;
                _break = function() {
                  return __iced_k(_results);
                };
                _continue = function() {
                  return iced.trampoline(function() {
                    ++_i;
                    return _while(__iced_k);
                  });
                };
                _next = function(__iced_next_arg) {
                  _results.push(__iced_next_arg);
                  return _continue();
                };
                if (!(_i < _len)) {
                  return _break();
                } else {
                  f = _ref[_i];
                  url = _this.make_url({
                    hostname: hostname,
                    protocol: protocol,
                    pathname: f
                  });
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/jacko/keybase-proofs/src/scrapers/generic_web_site.iced",
                      funcname: "GenericWebSiteScraper.hunt2"
                    });
                    _this._check_url({
                      url: url,
                      proof_text_check: proof_text_check
                    }, __iced_deferrals.defer({
                      assign_fn: (function() {
                        return function() {
                          err = arguments[0];
                          return rc = arguments[1];
                        };
                      })(),
                      lineno: 66
                    }));
                    __iced_deferrals._fulfill();
                  })(function() {
                    _this.log("| hunt " + url + " -> " + rc);
                    (function(__iced_k) {
                      if (rc === v_codes.OK) {
                        out = {
                          api_url: url,
                          human_url: url,
                          remote_id: url
                        };
                        (function(__iced_k) {
_break()
                        })(__iced_k);
                      } else {
                        (function(__iced_k) {
                          if (rc === v_codes.HTTP_400 || rc === v_codes.HTTP_500 || rc === v_codes.NOT_FOUND || rc === v_codes.PERMISSION_DENIED) {
                            (function(__iced_k) {
_continue()
                            })(__iced_k);
                          } else {
                            (function(__iced_k) {
_break()
                            })(__iced_k);
                          }
                        })(__iced_k);
                      }
                    })(_next);
                  });
                }
              };
              _while(__iced_k);
            })(__iced_k);
          }
        });
      })(this)((function(_this) {
        return function() {
          out.rc = rc;
          return cb(err, out);
        };
      })(this));
    };

    GenericWebSiteScraper.prototype._check_api_url = function(_arg) {
      var api_url, f, hostname, protocol, _i, _len, _ref;
      api_url = _arg.api_url, hostname = _arg.hostname, protocol = _arg.protocol;
      _ref = this.FILES;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        f = _ref[_i];
        if (api_url.toLowerCase().indexOf(this.make_url({
          hostname: hostname,
          protocol: protocol,
          pathname: f
        })) >= 0) {
          return true;
        }
      }
      return false;
    };

    GenericWebSiteScraper.prototype.check_status = function(_arg, cb) {
      var api_url, err, hostname, proof_text_check, protocol, rc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      protocol = _arg.protocol, hostname = _arg.hostname, api_url = _arg.api_url, proof_text_check = _arg.proof_text_check;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/keybase-proofs/src/scrapers/generic_web_site.iced",
            funcname: "GenericWebSiteScraper.check_status"
          });
          _this._check_url({
            url: api_url,
            proof_text_check: proof_text_check
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return rc = arguments[1];
              };
            })(),
            lineno: 93
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, rc);
        };
      })(this));
    };

    return GenericWebSiteScraper;

  })(BaseScraper);

}).call(this);
