/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public class ConfigFileLoader {
    private static final File CATALINA_BASE_FILE = new File(System.getProperty("catalina.base"));
    private static final URI CATALINA_BASE_URI = CATALINA_BASE_FILE.toURI();

    private ConfigFileLoader() {
    }

    public static InputStream getInputStream(String location) throws IOException {
        File file = new File(location);
        if (!file.isAbsolute()) {
            file = new File(CATALINA_BASE_FILE, location);
        }
        if (file.isFile()) {
            return new FileInputStream(file);
        }
        URI uri = CATALINA_BASE_URI.resolve(location);
        return uri.toURL().openStream();
    }
}

