/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.NoSuchNodeException;
import org.elasticsearch.action.PrimaryMissingActionException;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.TimestampParsingException;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.cluster.IncompatibleClusterStateVersionException;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.elasticsearch.cluster.routing.IllegalShardRoutingStateException;
import org.elasticsearch.cluster.routing.RoutingException;
import org.elasticsearch.cluster.routing.RoutingValidationException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobStoreException;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.io.stream.NotSerializableExceptionWrapper;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.support.LoggerMessageFormat;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.NoClassSettingsException;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.util.CancellableThreads;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.UncategorizedExecutionException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.gateway.GatewayException;
import org.elasticsearch.http.BindHttpException;
import org.elasticsearch.http.HttpException;
import org.elasticsearch.index.AlreadyExpiredException;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexShardAlreadyExistsException;
import org.elasticsearch.index.engine.CreateFailedEngineException;
import org.elasticsearch.index.engine.DeleteByQueryFailedEngineException;
import org.elasticsearch.index.engine.DeleteFailedEngineException;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.DocumentSourceMissingException;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineCreationFailureException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.FlushFailedEngineException;
import org.elasticsearch.index.engine.FlushNotAllowedEngineException;
import org.elasticsearch.index.engine.IndexFailedEngineException;
import org.elasticsearch.index.engine.RecoveryEngineException;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.SnapshotFailedEngineException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.StrictDynamicMappingException;
import org.elasticsearch.index.percolator.PercolatorException;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardNotRecoveringException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardRecoveringException;
import org.elasticsearch.index.shard.IndexShardRecoveryException;
import org.elasticsearch.index.shard.IndexShardRelocatedException;
import org.elasticsearch.index.shard.IndexShardStartedException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.index.shard.TranslogRecoveryPerformer;
import org.elasticsearch.index.snapshots.IndexShardRestoreException;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.elasticsearch.index.translog.TranslogCorruptedException;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TruncatedTranslogException;
import org.elasticsearch.indices.AliasFilterParsingException;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.indices.IndexCreationException;
import org.elasticsearch.indices.IndexPrimaryShardNotAllocatedException;
import org.elasticsearch.indices.IndexTemplateAlreadyExistsException;
import org.elasticsearch.indices.IndexTemplateMissingException;
import org.elasticsearch.indices.InvalidAliasNameException;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.indices.InvalidIndexTemplateException;
import org.elasticsearch.indices.InvalidTypeNameException;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.indices.recovery.DelayRecoveryException;
import org.elasticsearch.indices.recovery.RecoverFilesRecoveryException;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.percolator.PercolateException;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.RepositoryVerificationException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.admin.indices.alias.delete.AliasesNotFoundException;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.expression.ExpressionScriptCompilationException;
import org.elasticsearch.script.expression.ExpressionScriptExecutionException;
import org.elasticsearch.script.groovy.GroovyScriptCompilationException;
import org.elasticsearch.script.groovy.GroovyScriptExecutionException;
import org.elasticsearch.search.SearchContextException;
import org.elasticsearch.search.SearchContextMissingException;
import org.elasticsearch.search.SearchException;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.InvalidAggregationPathException;
import org.elasticsearch.search.builder.SearchSourceBuilderException;
import org.elasticsearch.search.dfs.DfsPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.search.warmer.IndexWarmerMissingException;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.InvalidSnapshotNameException;
import org.elasticsearch.snapshots.SnapshotCreationException;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotRestoreException;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.ActionTransportException;
import org.elasticsearch.transport.BindTransportException;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.NodeDisconnectedException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.NodeShouldNotConnectException;
import org.elasticsearch.transport.NotSerializableTransportException;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportSerializationException;
import org.elasticsearch.transport.netty.SizeHeaderFrameDecoder;

public class ElasticsearchException
extends RuntimeException
implements ToXContent {
    public static final String REST_EXCEPTION_SKIP_CAUSE = "rest.exception.cause.skip";
    public static final String REST_EXCEPTION_SKIP_STACK_TRACE = "rest.exception.stacktrace.skip";
    public static final boolean REST_EXCEPTION_SKIP_STACK_TRACE_DEFAULT = true;
    public static final boolean REST_EXCEPTION_SKIP_CAUSE_DEFAULT = false;
    private static final String INDEX_HEADER_KEY = "es.index";
    private static final String SHARD_HEADER_KEY = "es.shard";
    private static final String RESOURCE_HEADER_TYPE_KEY = "es.resource.type";
    private static final String RESOURCE_HEADER_ID_KEY = "es.resource.id";
    static final Map<Integer, Constructor<? extends ElasticsearchException>> ID_TO_SUPPLIER;
    private static final Map<Class<? extends ElasticsearchException>, Integer> CLASS_TO_ID;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public ElasticsearchException(Throwable cause) {
        super(cause);
    }

    public ElasticsearchException(String msg, Object ... args) {
        super(LoggerMessageFormat.format(msg, args));
    }

    public ElasticsearchException(String msg, Throwable cause, Object ... args) {
        super(LoggerMessageFormat.format(msg, args), cause);
    }

    public ElasticsearchException(StreamInput in) throws IOException {
        super(in.readOptionalString(), (Throwable)in.readThrowable());
        ElasticsearchException.readStackTrace(this, in);
        int numKeys = in.readVInt();
        for (int i = 0; i < numKeys; ++i) {
            String key = in.readString();
            int numValues = in.readVInt();
            ArrayList<String> values = new ArrayList<String>(numValues);
            for (int j = 0; j < numValues; ++j) {
                values.add(in.readString());
            }
            this.headers.put(key, values);
        }
    }

    public void addHeader(String key, String ... value) {
        this.headers.put(key, Arrays.asList(value));
    }

    public void addHeader(String key, List<String> value) {
        this.headers.put(key, value);
    }

    public Set<String> getHeaderKeys() {
        return this.headers.keySet();
    }

    public List<String> getHeader(String key) {
        return this.headers.get(key);
    }

    public RestStatus status() {
        Throwable cause = this.unwrapCause();
        if (cause == this) {
            return RestStatus.INTERNAL_SERVER_ERROR;
        }
        return ExceptionsHelper.status(cause);
    }

    public Throwable unwrapCause() {
        return ExceptionsHelper.unwrapCause(this);
    }

    public String getDetailedMessage() {
        if (this.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.toString()).append("; ");
            if (this.getCause() instanceof ElasticsearchException) {
                sb.append(((ElasticsearchException)this.getCause()).getDetailedMessage());
            } else {
                sb.append(this.getCause());
            }
            return sb.toString();
        }
        return super.toString();
    }

    public Throwable getRootCause() {
        Throwable rootCause = this;
        for (Throwable cause = this.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    public boolean contains(Class exType) {
        if (exType == null) {
            return false;
        }
        if (exType.isInstance(this)) {
            return true;
        }
        Throwable cause = this.getCause();
        if (cause == this) {
            return false;
        }
        if (cause instanceof ElasticsearchException) {
            return ((ElasticsearchException)cause).contains(exType);
        }
        while (cause != null) {
            if (exType.isInstance(cause)) {
                return true;
            }
            if (cause.getCause() == cause) break;
            cause = cause.getCause();
        }
        return false;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.getMessage());
        out.writeThrowable(this.getCause());
        ElasticsearchException.writeStackTraces(this, out);
        out.writeVInt(this.headers.size());
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            out.writeString(entry.getKey());
            out.writeVInt(entry.getValue().size());
            for (String v : entry.getValue()) {
                out.writeString(v);
            }
        }
    }

    public static ElasticsearchException readException(StreamInput input, int id) throws IOException {
        Constructor<? extends ElasticsearchException> elasticsearchException = ID_TO_SUPPLIER.get(id);
        if (elasticsearchException == null) {
            throw new IllegalStateException("unknown exception for id: " + id);
        }
        try {
            return elasticsearchException.newInstance(input);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IOException("failed to read exception for id [" + id + "]", e);
        }
    }

    public static boolean isRegistered(Class<? extends Throwable> exception) {
        return CLASS_TO_ID.containsKey(exception);
    }

    static Set<Class<? extends ElasticsearchException>> getRegisteredKeys() {
        return CLASS_TO_ID.keySet();
    }

    public static int getId(Class<? extends ElasticsearchException> exception) {
        return CLASS_TO_ID.get(exception);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Throwable ex = ExceptionsHelper.unwrapCause(this);
        if (ex != this) {
            ElasticsearchException.toXContent(builder, params, this);
        } else {
            builder.field("type", this.getExceptionName());
            builder.field("reason", this.getMessage());
            for (String key : this.headers.keySet()) {
                if (!key.startsWith("es.")) continue;
                List<String> values = this.headers.get(key);
                this.xContentHeader(builder, key.substring("es.".length()), values);
            }
            this.innerToXContent(builder, params);
            this.renderHeader(builder, params);
            if (!params.paramAsBoolean(REST_EXCEPTION_SKIP_STACK_TRACE, true)) {
                builder.field("stack_trace", ExceptionsHelper.stackTrace(this));
            }
        }
        return builder;
    }

    protected void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.causeToXContent(builder, params);
    }

    protected void causeToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Throwable cause = this.getCause();
        if (cause != null && !params.paramAsBoolean(REST_EXCEPTION_SKIP_CAUSE, false)) {
            builder.field("caused_by");
            builder.startObject();
            ElasticsearchException.toXContent(builder, params, cause);
            builder.endObject();
        }
    }

    protected final void renderHeader(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasHeader = false;
        for (String key : this.headers.keySet()) {
            if (key.startsWith("es.")) continue;
            if (!hasHeader) {
                builder.startObject("header");
                hasHeader = true;
            }
            List<String> values = this.headers.get(key);
            this.xContentHeader(builder, key, values);
        }
        if (hasHeader) {
            builder.endObject();
        }
    }

    private void xContentHeader(XContentBuilder builder, String key, List<String> values) throws IOException {
        if (values != null && !values.isEmpty()) {
            if (values.size() == 1) {
                builder.field(key, values.get(0));
            } else {
                builder.startArray(key);
                for (String value : values) {
                    builder.value(value);
                }
                builder.endArray();
            }
        }
    }

    public static void toXContent(XContentBuilder builder, ToXContent.Params params, Throwable ex) throws IOException {
        if ((ex = ExceptionsHelper.unwrapCause(ex)) instanceof ElasticsearchException) {
            ((ElasticsearchException)ex).toXContent(builder, params);
        } else {
            builder.field("type", ElasticsearchException.getExceptionName(ex));
            builder.field("reason", ex.getMessage());
            if (ex.getCause() != null) {
                builder.field("caused_by");
                builder.startObject();
                ElasticsearchException.toXContent(builder, params, ex.getCause());
                builder.endObject();
            }
            if (!params.paramAsBoolean(REST_EXCEPTION_SKIP_STACK_TRACE, true)) {
                builder.field("stack_trace", ExceptionsHelper.stackTrace(ex));
            }
        }
    }

    public ElasticsearchException[] guessRootCauses() {
        Throwable cause = this.getCause();
        if (cause != null && cause instanceof ElasticsearchException) {
            return ((ElasticsearchException)cause).guessRootCauses();
        }
        return new ElasticsearchException[]{this};
    }

    public static ElasticsearchException[] guessRootCauses(Throwable t) {
        Throwable ex = ExceptionsHelper.unwrapCause(t);
        if (ex instanceof ElasticsearchException) {
            return ((ElasticsearchException)ex).guessRootCauses();
        }
        return new ElasticsearchException[]{new ElasticsearchException(t.getMessage(), t, new Object[0]){

            @Override
            protected String getExceptionName() {
                return 1.getExceptionName(this.getCause());
            }
        }};
    }

    protected String getExceptionName() {
        return ElasticsearchException.getExceptionName(this);
    }

    public static String getExceptionName(Throwable ex) {
        String simpleName = ex.getClass().getSimpleName();
        if (simpleName.startsWith("Elasticsearch")) {
            simpleName = simpleName.substring("Elasticsearch".length());
        }
        return Strings.toUnderscoreCase(simpleName);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.headers.containsKey(INDEX_HEADER_KEY)) {
            builder.append('[').append(this.getIndex()).append(']');
            if (this.headers.containsKey(SHARD_HEADER_KEY)) {
                builder.append('[').append(this.getShardId()).append(']');
            }
            builder.append(' ');
        }
        return builder.append(ExceptionsHelper.detailedMessage(this).trim()).toString();
    }

    public static <T extends Throwable> T readStackTrace(T throwable, StreamInput in) throws IOException {
        int stackTraceElements = in.readVInt();
        StackTraceElement[] stackTrace = new StackTraceElement[stackTraceElements];
        for (int i = 0; i < stackTraceElements; ++i) {
            String declaringClasss = in.readString();
            String fileName = in.readOptionalString();
            String methodName = in.readString();
            int lineNumber = in.readVInt();
            stackTrace[i] = new StackTraceElement(declaringClasss, methodName, fileName, lineNumber);
        }
        throwable.setStackTrace(stackTrace);
        int numSuppressed = in.readVInt();
        for (int i = 0; i < numSuppressed; ++i) {
            throwable.addSuppressed((Throwable)in.readThrowable());
        }
        return throwable;
    }

    public static <T extends Throwable> T writeStackTraces(T throwable, StreamOutput out) throws IOException {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        out.writeVInt(stackTrace.length);
        for (StackTraceElement element : stackTrace) {
            out.writeString(element.getClassName());
            out.writeOptionalString(element.getFileName());
            out.writeString(element.getMethodName());
            out.writeVInt(element.getLineNumber());
        }
        Throwable[] suppressed = throwable.getSuppressed();
        out.writeVInt(suppressed.length);
        for (Throwable t : suppressed) {
            out.writeThrowable(t);
        }
        return throwable;
    }

    public String getIndex() {
        List<String> index = this.getHeader(INDEX_HEADER_KEY);
        if (index != null && !index.isEmpty()) {
            return index.get(0);
        }
        return null;
    }

    public ShardId getShardId() {
        List<String> shard = this.getHeader(SHARD_HEADER_KEY);
        if (shard != null && !shard.isEmpty()) {
            return new ShardId(this.getIndex(), Integer.parseInt(shard.get(0)));
        }
        return null;
    }

    public void setIndex(Index index) {
        if (index != null) {
            this.addHeader(INDEX_HEADER_KEY, index.getName());
        }
    }

    public void setIndex(String index) {
        if (index != null) {
            this.addHeader(INDEX_HEADER_KEY, index);
        }
    }

    public void setShard(ShardId shardId) {
        if (shardId != null) {
            this.addHeader(INDEX_HEADER_KEY, shardId.getIndex());
            this.addHeader(SHARD_HEADER_KEY, Integer.toString(shardId.id()));
        }
    }

    public void setResources(String type, String ... id) {
        assert (type != null);
        this.addHeader(RESOURCE_HEADER_ID_KEY, id);
        this.addHeader(RESOURCE_HEADER_TYPE_KEY, type);
    }

    public List<String> getResourceId() {
        return this.getHeader(RESOURCE_HEADER_ID_KEY);
    }

    public String getResourceType() {
        List<String> header = this.getHeader(RESOURCE_HEADER_TYPE_KEY);
        if (header != null && !header.isEmpty()) {
            assert (header.size() == 1);
            return header.get(0);
        }
        return null;
    }

    public static void renderThrowable(XContentBuilder builder, ToXContent.Params params, Throwable t) throws IOException {
        builder.startObject("error");
        ElasticsearchException[] rootCauses = ElasticsearchException.guessRootCauses(t);
        builder.field("root_cause");
        builder.startArray();
        for (ElasticsearchException rootCause : rootCauses) {
            builder.startObject();
            rootCause.toXContent(builder, new ToXContent.DelegatingMapParams(Collections.singletonMap(REST_EXCEPTION_SKIP_CAUSE, "true"), params));
            builder.endObject();
        }
        builder.endArray();
        ElasticsearchException.toXContent(builder, params, t);
        builder.endObject();
    }

    static {
        HashMap<Class, Integer> exceptions = new HashMap<Class, Integer>();
        exceptions.put(IndexShardSnapshotFailedException.class, 0);
        exceptions.put(DfsPhaseExecutionException.class, 1);
        exceptions.put(CancellableThreads.ExecutionCancelledException.class, 2);
        exceptions.put(MasterNotDiscoveredException.class, 3);
        exceptions.put(ElasticsearchSecurityException.class, 4);
        exceptions.put(IndexShardRestoreException.class, 5);
        exceptions.put(IndexClosedException.class, 6);
        exceptions.put(BindHttpException.class, 7);
        exceptions.put(ReduceSearchPhaseException.class, 8);
        exceptions.put(NodeClosedException.class, 9);
        exceptions.put(SnapshotFailedEngineException.class, 10);
        exceptions.put(ShardNotFoundException.class, 11);
        exceptions.put(ConnectTransportException.class, 12);
        exceptions.put(NotSerializableTransportException.class, 13);
        exceptions.put(ResponseHandlerFailureTransportException.class, 14);
        exceptions.put(IndexCreationException.class, 15);
        exceptions.put(IndexNotFoundException.class, 16);
        exceptions.put(IllegalShardRoutingStateException.class, 17);
        exceptions.put(BroadcastShardOperationFailedException.class, 18);
        exceptions.put(ResourceNotFoundException.class, 19);
        exceptions.put(ActionTransportException.class, 20);
        exceptions.put(ElasticsearchGenerationException.class, 21);
        exceptions.put(CreateFailedEngineException.class, 22);
        exceptions.put(IndexShardStartedException.class, 23);
        exceptions.put(SearchContextMissingException.class, 24);
        exceptions.put(ScriptException.class, 25);
        exceptions.put(TranslogRecoveryPerformer.BatchOperationException.class, 26);
        exceptions.put(SnapshotCreationException.class, 27);
        exceptions.put(DeleteFailedEngineException.class, 28);
        exceptions.put(DocumentMissingException.class, 29);
        exceptions.put(SnapshotException.class, 30);
        exceptions.put(InvalidAliasNameException.class, 31);
        exceptions.put(InvalidIndexNameException.class, 32);
        exceptions.put(IndexPrimaryShardNotAllocatedException.class, 33);
        exceptions.put(TransportException.class, 34);
        exceptions.put(ElasticsearchParseException.class, 35);
        exceptions.put(SearchException.class, 36);
        exceptions.put(MapperException.class, 37);
        exceptions.put(InvalidTypeNameException.class, 38);
        exceptions.put(SnapshotRestoreException.class, 39);
        exceptions.put(QueryParsingException.class, 40);
        exceptions.put(IndexShardClosedException.class, 41);
        exceptions.put(RecoverFilesRecoveryException.class, 42);
        exceptions.put(TruncatedTranslogException.class, 43);
        exceptions.put(RecoveryFailedException.class, 44);
        exceptions.put(IndexShardRelocatedException.class, 45);
        exceptions.put(NodeShouldNotConnectException.class, 46);
        exceptions.put(IndexTemplateAlreadyExistsException.class, 47);
        exceptions.put(TranslogCorruptedException.class, 48);
        exceptions.put(ClusterBlockException.class, 49);
        exceptions.put(FetchPhaseExecutionException.class, 50);
        exceptions.put(IndexShardAlreadyExistsException.class, 51);
        exceptions.put(VersionConflictEngineException.class, 52);
        exceptions.put(EngineException.class, 53);
        exceptions.put(DocumentAlreadyExistsException.class, 54);
        exceptions.put(NoSuchNodeException.class, 55);
        exceptions.put(SettingsException.class, 56);
        exceptions.put(IndexTemplateMissingException.class, 57);
        exceptions.put(SendRequestTransportException.class, 58);
        exceptions.put(EsRejectedExecutionException.class, 59);
        exceptions.put(Lucene.EarlyTerminationException.class, 60);
        exceptions.put(RoutingValidationException.class, 61);
        exceptions.put(NotSerializableExceptionWrapper.class, 62);
        exceptions.put(AliasFilterParsingException.class, 63);
        exceptions.put(DeleteByQueryFailedEngineException.class, 64);
        exceptions.put(GatewayException.class, 65);
        exceptions.put(IndexShardNotRecoveringException.class, 66);
        exceptions.put(HttpException.class, 67);
        exceptions.put(ElasticsearchException.class, 68);
        exceptions.put(SnapshotMissingException.class, 69);
        exceptions.put(PrimaryMissingActionException.class, 70);
        exceptions.put(FailedNodeException.class, 71);
        exceptions.put(SearchParseException.class, 72);
        exceptions.put(ConcurrentSnapshotExecutionException.class, 73);
        exceptions.put(BlobStoreException.class, 74);
        exceptions.put(IncompatibleClusterStateVersionException.class, 75);
        exceptions.put(RecoveryEngineException.class, 76);
        exceptions.put(UncategorizedExecutionException.class, 77);
        exceptions.put(TimestampParsingException.class, 78);
        exceptions.put(RoutingMissingException.class, 79);
        exceptions.put(IndexFailedEngineException.class, 80);
        exceptions.put(IndexShardRestoreFailedException.class, 81);
        exceptions.put(RepositoryException.class, 82);
        exceptions.put(ReceiveTimeoutTransportException.class, 83);
        exceptions.put(NodeDisconnectedException.class, 84);
        exceptions.put(AlreadyExpiredException.class, 85);
        exceptions.put(AggregationExecutionException.class, 86);
        exceptions.put(MergeMappingException.class, 87);
        exceptions.put(InvalidIndexTemplateException.class, 88);
        exceptions.put(PercolateException.class, 89);
        exceptions.put(RefreshFailedEngineException.class, 90);
        exceptions.put(AggregationInitializationException.class, 91);
        exceptions.put(DelayRecoveryException.class, 92);
        exceptions.put(IndexWarmerMissingException.class, 93);
        exceptions.put(NoNodeAvailableException.class, 94);
        exceptions.put(GroovyScriptCompilationException.class, 95);
        exceptions.put(InvalidSnapshotNameException.class, 96);
        exceptions.put(IllegalIndexShardStateException.class, 97);
        exceptions.put(IndexShardSnapshotException.class, 98);
        exceptions.put(IndexShardNotStartedException.class, 99);
        exceptions.put(SearchPhaseExecutionException.class, 100);
        exceptions.put(ActionNotFoundTransportException.class, 101);
        exceptions.put(TransportSerializationException.class, 102);
        exceptions.put(RemoteTransportException.class, 103);
        exceptions.put(EngineCreationFailureException.class, 104);
        exceptions.put(RoutingException.class, 105);
        exceptions.put(IndexShardRecoveryException.class, 106);
        exceptions.put(RepositoryMissingException.class, 107);
        exceptions.put(PercolatorException.class, 108);
        exceptions.put(DocumentSourceMissingException.class, 109);
        exceptions.put(FlushNotAllowedEngineException.class, 110);
        exceptions.put(NoClassSettingsException.class, 111);
        exceptions.put(BindTransportException.class, 112);
        exceptions.put(AliasesNotFoundException.class, 113);
        exceptions.put(IndexShardRecoveringException.class, 114);
        exceptions.put(TranslogException.class, 115);
        exceptions.put(ProcessClusterEventTimeoutException.class, 116);
        exceptions.put(TransportReplicationAction.RetryOnPrimaryException.class, 117);
        exceptions.put(ElasticsearchTimeoutException.class, 118);
        exceptions.put(QueryPhaseExecutionException.class, 119);
        exceptions.put(RepositoryVerificationException.class, 120);
        exceptions.put(InvalidAggregationPathException.class, 121);
        exceptions.put(GroovyScriptExecutionException.class, 122);
        exceptions.put(IndexAlreadyExistsException.class, 123);
        exceptions.put(Script.ScriptParseException.class, 124);
        exceptions.put(SizeHeaderFrameDecoder.HttpOnTransportException.class, 125);
        exceptions.put(MapperParsingException.class, 126);
        exceptions.put(SearchContextException.class, 127);
        exceptions.put(SearchSourceBuilderException.class, 128);
        exceptions.put(EngineClosedException.class, 129);
        exceptions.put(NoShardAvailableActionException.class, 130);
        exceptions.put(UnavailableShardsException.class, 131);
        exceptions.put(FlushFailedEngineException.class, 132);
        exceptions.put(CircuitBreakingException.class, 133);
        exceptions.put(NodeNotConnectedException.class, 134);
        exceptions.put(StrictDynamicMappingException.class, 135);
        exceptions.put(TransportReplicationAction.RetryOnReplicaException.class, 136);
        exceptions.put(TypeMissingException.class, 137);
        exceptions.put(ExpressionScriptCompilationException.class, 138);
        exceptions.put(ExpressionScriptExecutionException.class, 139);
        HashMap idToSupplier = new HashMap();
        for (Map.Entry e : exceptions.entrySet()) {
            try {
                Constructor constructor = ((Class)e.getKey()).getDeclaredConstructor(StreamInput.class);
                if (constructor == null) {
                    throw new IllegalStateException(((Class)e.getKey()).getName() + " has not StreamInput ctor");
                }
                assert ((Integer)e.getValue() >= 0);
                if (idToSupplier.get((int)((Integer)e.getValue())) != null) {
                    throw new IllegalStateException("ordinal [" + (Integer)e.getValue() + "] is used more than once");
                }
                idToSupplier.put((Integer)e.getValue(), constructor);
            }
            catch (NoSuchMethodException t) {
                throw new RuntimeException("failed to register [" + ((Class)e.getKey()).getName() + "] exception must have a public StreamInput ctor", t);
            }
        }
        ID_TO_SUPPLIER = Collections.unmodifiableMap(idToSupplier);
        CLASS_TO_ID = Collections.unmodifiableMap(exceptions);
    }
}

