/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.ZoomToAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.relation.IMemberModelListener;
import org.openstreetmap.josm.gui.dialogs.relation.MemberRoleCellEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.HighlightHelper;
import org.openstreetmap.josm.gui.widgets.OsmPrimitivesTable;
import org.openstreetmap.josm.tools.I18n;

public class MemberTable
extends OsmPrimitivesTable
implements IMemberModelListener {
    private ZoomToGapAction zoomToGap;
    private final transient HighlightHelper highlightHelper = new HighlightHelper();
    private boolean highlightEnabled;
    private transient ListSelectionListener highlighterListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (Main.isDisplayingMapView()) {
                Collection<RelationMember> collection = MemberTable.this.getMemberTableModel().getSelectedMembers();
                final ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
                for (RelationMember relationMember : collection) {
                    if (!relationMember.getMember().isUsable()) continue;
                    arrayList.add(relationMember.getMember());
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (Main.isDisplayingMapView() && MemberTable.this.highlightHelper.highlightOnly(arrayList)) {
                            Main.map.mapView.repaint();
                        }
                    }
                });
            }
        }
    };

    public MemberTable(OsmDataLayer osmDataLayer, Relation relation, MemberTableModel memberTableModel) {
        super(memberTableModel, (TableColumnModel)new MemberTableColumnModel(osmDataLayer.data, relation), (ListSelectionModel)memberTableModel.getSelectionModel());
        this.setLayer(osmDataLayer);
        memberTableModel.addMemberModelListener(this);
        this.init();
    }

    protected void init() {
        MemberRoleCellEditor memberRoleCellEditor = (MemberRoleCellEditor)this.getColumnModel().getColumn(0).getCellEditor();
        this.setRowHeight(memberRoleCellEditor.getEditor().getPreferredSize().height);
        this.setAutoResizeMode(4);
        this.setSelectionMode(2);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
        this.initHighlighting();
        this.getActionMap().put("selectNextColumnCell", new SelectNextColumnCellAction());
        this.getActionMap().put("selectPreviousColumnCell", new SelectPreviousColumnCellAction());
    }

    @Override
    protected ZoomToAction buildZoomToAction() {
        return new ZoomToAction(this);
    }

    @Override
    protected JPopupMenu buildPopupMenu() {
        JPopupMenu jPopupMenu = super.buildPopupMenu();
        this.zoomToGap = new ZoomToGapAction();
        MapView.addLayerChangeListener(this.zoomToGap);
        this.getSelectionModel().addListSelectionListener(this.zoomToGap);
        jPopupMenu.add(this.zoomToGap);
        jPopupMenu.addSeparator();
        jPopupMenu.add(new SelectPreviousGapAction());
        jPopupMenu.add(new SelectNextGapAction());
        return jPopupMenu;
    }

    @Override
    public Dimension getPreferredSize() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof JViewport); container = container.getParent()) {
        }
        if (container != null) {
            Dimension dimension = super.getPreferredSize();
            dimension.width = container.getSize().width;
            return dimension;
        }
        return super.getPreferredSize();
    }

    @Override
    public void makeMemberVisible(int n) {
        this.scrollRectToVisible(this.getCellRect(n, 0, true));
    }

    private void initHighlighting() {
        this.highlightEnabled = Main.pref.getBoolean("draw.target-highlight", true);
        if (!this.highlightEnabled) {
            return;
        }
        this.getMemberTableModel().getSelectionModel().addListSelectionListener(this.highlighterListener);
        if (Main.isDisplayingMapView()) {
            HighlightHelper.clearAllHighlighted();
            Main.map.mapView.repaint();
        }
    }

    @Override
    public void unlinkAsListener() {
        super.unlinkAsListener();
        MapView.removeLayerChangeListener(this.zoomToGap);
    }

    public void stopHighlighting() {
        if (this.highlighterListener == null) {
            return;
        }
        if (!this.highlightEnabled) {
            return;
        }
        this.getMemberTableModel().getSelectionModel().removeListSelectionListener(this.highlighterListener);
        this.highlighterListener = null;
        if (Main.isDisplayingMapView()) {
            HighlightHelper.clearAllHighlighted();
            Main.map.mapView.repaint();
        }
    }

    protected MemberTableModel getMemberTableModel() {
        return (MemberTableModel)this.getModel();
    }

    private class ZoomToGapAction
    extends AbstractAction
    implements MapView.LayerChangeListener,
    ListSelectionListener {
        private final Collection<WayConnectionType.Direction> connectionTypesOfInterest = Arrays.asList(WayConnectionType.Direction.FORWARD, WayConnectionType.Direction.BACKWARD);

        ZoomToGapAction() {
            this.putValue("Name", I18n.tr("Zoom to Gap", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Zoom to the gap in the way sequence", new Object[0]));
            this.updateEnabledState();
        }

        private WayConnectionType getConnectionType() {
            return MemberTable.this.getMemberTableModel().getWayConnection(MemberTable.this.getSelectedRows()[0]);
        }

        private boolean hasGap() {
            WayConnectionType wayConnectionType = this.getConnectionType();
            return this.connectionTypesOfInterest.contains((Object)wayConnectionType.direction) && (!wayConnectionType.linkNext || !wayConnectionType.linkPrev);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WayConnectionType wayConnectionType = this.getConnectionType();
            Way way = (Way)MemberTable.this.getMemberTableModel().getReferredPrimitive(MemberTable.this.getSelectedRows()[0]);
            if (!wayConnectionType.linkPrev) {
                MemberTable.this.getLayer().data.setSelected(WayConnectionType.Direction.FORWARD.equals((Object)wayConnectionType.direction) ? way.firstNode() : way.lastNode());
                AutoScaleAction.autoScale("selection");
            } else if (!wayConnectionType.linkNext) {
                MemberTable.this.getLayer().data.setSelected(WayConnectionType.Direction.FORWARD.equals((Object)wayConnectionType.direction) ? way.lastNode() : way.firstNode());
                AutoScaleAction.autoScale("selection");
            }
        }

        private void updateEnabledState() {
            this.setEnabled(Main.main != null && Main.main.getEditLayer() == MemberTable.this.getLayer() && MemberTable.this.getSelectedRowCount() == 1 && this.hasGap());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        @Override
        public void activeLayerChange(Layer layer, Layer layer2) {
            this.updateEnabledState();
        }

        @Override
        public void layerAdded(Layer layer) {
            this.updateEnabledState();
        }

        @Override
        public void layerRemoved(Layer layer) {
            this.updateEnabledState();
        }
    }

    private class SelectNextGapAction
    extends AbstractAction {
        SelectNextGapAction() {
            this.putValue("Name", I18n.tr("Select next Gap", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Select the next relation member which gives rise to a gap", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            for (n = MemberTable.this.getSelectedRow() + 1; n < MemberTable.this.getRowCount() && MemberTable.this.getMemberTableModel().getWayConnection((int)n).linkNext; ++n) {
            }
            if (n < MemberTable.this.getRowCount()) {
                MemberTable.this.getSelectionModel().setSelectionInterval(n, n);
            }
        }
    }

    private class SelectPreviousGapAction
    extends AbstractAction {
        SelectPreviousGapAction() {
            this.putValue("Name", I18n.tr("Select previous Gap", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Select the previous relation member which gives rise to a gap", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            for (n = MemberTable.this.getSelectedRow() - 1; n >= 0 && MemberTable.this.getMemberTableModel().getWayConnection((int)n).linkPrev; --n) {
            }
            if (n >= 0) {
                MemberTable.this.getSelectionModel().setSelectionInterval(n, n);
            }
        }
    }

    private class SelectPreviousColumnCellAction
    extends AbstractAction {
        private SelectPreviousColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = MemberTable.this.getSelectedColumn();
            int n2 = MemberTable.this.getSelectedRow();
            if (MemberTable.this.getCellEditor() != null) {
                MemberTable.this.getCellEditor().stopCellEditing();
            }
            if ((n > 0 || n2 > 0) && n2 > 0) {
                n = 0;
                --n2;
            }
            MemberTable.this.changeSelection(n2, n, false, false);
        }
    }

    class SelectNextColumnCellAction
    extends AbstractAction {
        SelectNextColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        public void run() {
            int n = MemberTable.this.getSelectedColumn();
            int n2 = MemberTable.this.getSelectedRow();
            if (MemberTable.this.getCellEditor() != null) {
                MemberTable.this.getCellEditor().stopCellEditing();
            }
            if (n == 0 && n2 < MemberTable.this.getRowCount() - 1) {
                ++n2;
            } else if (n2 < MemberTable.this.getRowCount() - 1) {
                n = 0;
                ++n2;
            } else {
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                keyboardFocusManager.focusNextComponent();
                return;
            }
            MemberTable.this.changeSelection(n2, n, false, false);
        }
    }
}

