/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.actions.ToggleUploadDiscouragedLayerAction;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxConstants;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.DatasetConsistencyTest;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveComparator;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.MapRendererFactory;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.AbstractIOTask;
import org.openstreetmap.josm.gui.io.AbstractUploadDialog;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.io.UploadLayerTask;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.FilteredCollection;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.date.DateUtils;

public class OsmDataLayer
extends AbstractModifiableLayer
implements DataSetListenerAdapter.Listener,
SelectionChangedListener {
    public static final String REQUIRES_SAVE_TO_DISK_PROP = OsmDataLayer.class.getName() + ".requiresSaveToDisk";
    public static final String REQUIRES_UPLOAD_TO_SERVER_PROP = OsmDataLayer.class.getName() + ".requiresUploadToServer";
    private boolean requiresSaveToFile;
    private boolean requiresUploadToServer;
    private boolean isChanged = true;
    private int highlightUpdateCount;
    public final List<TestError> validationErrors = new ArrayList<TestError>();
    private static int dataLayerCounter;
    private final CopyOnWriteArrayList<LayerStateChangeListener> layerStateChangeListeners = new CopyOnWriteArrayList();
    public final DataSet data;
    private final ConflictCollection conflicts;
    private static volatile TexturePaint hatched;

    protected void setRequiresSaveToFile(boolean bl) {
        boolean bl2 = this.requiresSaveToFile;
        this.requiresSaveToFile = bl;
        if (bl2 != bl) {
            this.propertyChangeSupport.firePropertyChange(REQUIRES_SAVE_TO_DISK_PROP, bl2, bl);
        }
    }

    protected void setRequiresUploadToServer(boolean bl) {
        boolean bl2 = this.requiresUploadToServer;
        this.requiresUploadToServer = bl;
        if (bl2 != bl) {
            this.propertyChangeSupport.firePropertyChange(REQUIRES_UPLOAD_TO_SERVER_PROP, bl2, bl);
        }
    }

    public static String createNewName() {
        return I18n.tr("Data Layer {0}", ++dataLayerCounter);
    }

    public void addLayerStateChangeListener(LayerStateChangeListener layerStateChangeListener) {
        if (layerStateChangeListener != null) {
            this.layerStateChangeListeners.addIfAbsent(layerStateChangeListener);
        }
    }

    public void removeLayerPropertyChangeListener(LayerStateChangeListener layerStateChangeListener) {
        this.layerStateChangeListeners.remove(layerStateChangeListener);
    }

    public static Color getBackgroundColor() {
        return Main.pref != null ? Main.pref.getColor(I18n.marktr("background"), Color.BLACK) : Color.BLACK;
    }

    public static Color getOutsideColor() {
        return Main.pref != null ? Main.pref.getColor(I18n.marktr("outside downloaded area"), Color.YELLOW) : Color.YELLOW;
    }

    public static void createHatchTexture() {
        BufferedImage bufferedImage = new BufferedImage(15, 15, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(OsmDataLayer.getBackgroundColor());
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.fillRect(0, 0, 15, 15);
        graphics2D.setColor(OsmDataLayer.getOutsideColor());
        graphics2D.drawLine(0, 15, 15, 0);
        Rectangle rectangle = new Rectangle(0, 0, 15, 15);
        hatched = new TexturePaint(bufferedImage, rectangle);
    }

    public OsmDataLayer(DataSet dataSet, String string, File file) {
        super(string);
        CheckParameterUtil.ensureParameterNotNull(dataSet, "data");
        this.data = dataSet;
        this.setAssociatedFile(file);
        this.conflicts = new ConflictCollection();
        dataSet.addDataSetListener(new DataSetListenerAdapter(this));
        dataSet.addDataSetListener(MultipolygonCache.getInstance());
        DataSet.addSelectionListener(this);
    }

    protected ImageProvider getBaseIconProvider() {
        return new ImageProvider("layer", "osmdata_small");
    }

    @Override
    public Icon getIcon() {
        ImageProvider imageProvider = this.getBaseIconProvider().setMaxSize(ImageProvider.ImageSizes.LAYER);
        if (this.isUploadDiscouraged()) {
            imageProvider.addOverlay(new ImageOverlay(new ImageProvider("warning-small"), 0.5, 0.5, 1.0, 1.0));
        }
        return imageProvider.get();
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        Object object;
        boolean bl;
        this.isChanged = false;
        this.highlightUpdateCount = this.data.getHighlightUpdateCount();
        boolean bl2 = mapView.getActiveLayer() == this;
        boolean bl3 = !bl2 && Main.pref.getBoolean("draw.data.inactive_color", true);
        boolean bl4 = bl = !bl3 && mapView.isVirtualNodesEnabled();
        if (bl2 && Main.pref.getBoolean("draw.data.downloaded_area", true) && !this.data.dataSources.isEmpty()) {
            object = mapView.getBounds();
            ((Rectangle)object).grow(100, 100);
            Area area = new Area((Shape)object);
            for (Bounds bounds2 : this.data.getDataSourceBounds()) {
                if (bounds2.isCollapsed()) continue;
                Point point = mapView.getPoint(bounds2.getMin());
                Point point2 = mapView.getPoint(bounds2.getMax());
                Rectangle rectangle = new Rectangle(Math.min(point.x, point2.x), Math.min(point.y, point2.y), Math.abs(point2.x - point.x), Math.abs(point2.y - point.y));
                area.subtract(new Area(rectangle));
            }
            graphics2D.setPaint(hatched);
            graphics2D.fill(area);
        }
        object = MapRendererFactory.getInstance().createActiveRenderer(graphics2D, mapView, bl3);
        object.render(this.data, bl, bounds);
        Main.map.conflictDialog.paintConflicts(graphics2D, mapView);
    }

    @Override
    public String getToolTipText() {
        int n = new FilteredCollection<OsmPrimitive>((Collection<OsmPrimitive>)this.data.getNodes(), OsmPrimitive.nonDeletedPredicate).size();
        int n2 = new FilteredCollection<OsmPrimitive>((Collection<OsmPrimitive>)this.data.getWays(), OsmPrimitive.nonDeletedPredicate).size();
        int n3 = new FilteredCollection<OsmPrimitive>((Collection<OsmPrimitive>)this.data.getRelations(), OsmPrimitive.nonDeletedPredicate).size();
        String string = I18n.trn("{0} node", "{0} nodes", n, n) + ", ";
        string = string + I18n.trn("{0} way", "{0} ways", n2, n2) + ", ";
        string = string + I18n.trn("{0} relation", "{0} relations", n3, n3);
        File file = this.getAssociatedFile();
        if (file != null) {
            string = "<html>" + string + "<br>" + file.getPath() + "</html>";
        }
        return string;
    }

    @Override
    public void mergeFrom(Layer layer) {
        PleaseWaitProgressMonitor pleaseWaitProgressMonitor = new PleaseWaitProgressMonitor(I18n.tr("Merging layers", new Object[0]));
        pleaseWaitProgressMonitor.setCancelable(false);
        if (layer instanceof OsmDataLayer && ((OsmDataLayer)layer).isUploadDiscouraged()) {
            this.setUploadDiscouraged(true);
        }
        this.mergeFrom(((OsmDataLayer)layer).data, pleaseWaitProgressMonitor);
        pleaseWaitProgressMonitor.close();
    }

    public void mergeFrom(DataSet dataSet) {
        this.mergeFrom(dataSet, null);
    }

    public void mergeFrom(DataSet dataSet, ProgressMonitor progressMonitor) {
        DataSetMerger dataSetMerger = new DataSetMerger(this.data, dataSet);
        try {
            dataSetMerger.merge(progressMonitor);
        }
        catch (DataIntegrityProblemException dataIntegrityProblemException) {
            JOptionPane.showMessageDialog(Main.parent, dataIntegrityProblemException.getHtmlMessage() != null ? dataIntegrityProblemException.getHtmlMessage() : dataIntegrityProblemException.getMessage(), I18n.tr("Error", new Object[0]), 0);
            return;
        }
        Area area = this.data.getDataSourceArea();
        for (DataSource object : dataSet.dataSources) {
            if (area != null && area.contains(object.bounds.asRect())) continue;
            this.data.dataSources.add(object);
        }
        if (this.data.getVersion() == null) {
            this.data.setVersion(dataSet.getVersion());
        }
        int n = 0;
        for (Conflict<?> conflict : dataSetMerger.getConflicts()) {
            if (this.conflicts.hasConflict(conflict)) continue;
            ++n;
            this.conflicts.add(conflict);
        }
        if (Main.isDisplayingMapView()) {
            Main.map.mapView.repaint();
        }
        if (n > 0 && Main.map != null && Main.map.conflictDialog != null) {
            Main.map.conflictDialog.warnNumNewConflicts(n);
        }
    }

    @Override
    public boolean isMergable(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        for (Node node : this.data.getNodes()) {
            if (!node.isUsable()) continue;
            boundingXYVisitor.visit(node);
        }
    }

    public void cleanupAfterUpload(Collection<IPrimitive> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Main.main.undoRedo.clean(this);
        this.data.cleanupDeletedPrimitives();
        for (OsmPrimitive osmPrimitive : this.data.allPrimitives()) {
            if (!collection.contains(osmPrimitive)) continue;
            osmPrimitive.setModified(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getInfoComponent() {
        void var3_6;
        DataCountVisitor dataCountVisitor = new DataCountVisitor();
        for (OsmPrimitive object2 : this.data.allPrimitives()) {
            object2.accept(dataCountVisitor);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        String string = I18n.trn("{0} node", "{0} nodes", dataCountVisitor.nodes, dataCountVisitor.nodes);
        if (dataCountVisitor.deletedNodes > 0) {
            String string2 = string + " (" + I18n.trn("{0} deleted", "{0} deleted", dataCountVisitor.deletedNodes, dataCountVisitor.deletedNodes) + ')';
        }
        String string3 = I18n.trn("{0} way", "{0} ways", dataCountVisitor.ways, dataCountVisitor.ways);
        if (dataCountVisitor.deletedWays > 0) {
            string3 = string3 + " (" + I18n.trn("{0} deleted", "{0} deleted", dataCountVisitor.deletedWays, dataCountVisitor.deletedWays) + ')';
        }
        String string4 = I18n.trn("{0} relation", "{0} relations", dataCountVisitor.relations, dataCountVisitor.relations);
        if (dataCountVisitor.deletedRelations > 0) {
            string4 = string4 + " (" + I18n.trn("{0} deleted", "{0} deleted", dataCountVisitor.deletedRelations, dataCountVisitor.deletedRelations) + ')';
        }
        jPanel.add((Component)new JLabel(I18n.tr("{0} consists of:", this.getName())), GBC.eol());
        jPanel.add((Component)new JLabel((String)var3_6, ImageProvider.get("data", "node"), 0), GBC.eop().insets(15, 0, 0, 0));
        jPanel.add((Component)new JLabel(string3, ImageProvider.get("data", "way"), 0), GBC.eop().insets(15, 0, 0, 0));
        jPanel.add((Component)new JLabel(string4, ImageProvider.get("data", "relation"), 0), GBC.eop().insets(15, 0, 0, 0));
        jPanel.add((Component)new JLabel(I18n.tr("API version: {0}", this.data.getVersion() != null ? this.data.getVersion() : I18n.tr("unset", new Object[0]))), GBC.eop().insets(15, 0, 0, 0));
        if (this.isUploadDiscouraged()) {
            jPanel.add((Component)new JLabel(I18n.tr("Upload is discouraged", new Object[0])), GBC.eop().insets(15, 0, 0, 0));
        }
        return jPanel;
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.addAll(Arrays.asList(LayerListDialog.getInstance().createActivateLayerAction(this), LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, LayerListDialog.getInstance().createMergeLayerAction(this), LayerListDialog.getInstance().createDuplicateLayerAction(this), new Layer.LayerSaveAction(this), new Layer.LayerSaveAsAction(this)));
        if (ExpertToggleAction.isExpert()) {
            arrayList.addAll(Arrays.asList(new Layer.LayerGpxExportAction(this), new ConvertToGpxLayerAction()));
        }
        arrayList.addAll(Arrays.asList(Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(this.getAssociatedFile(), this)));
        if (ExpertToggleAction.isExpert() && Main.pref.getBoolean("data.layer.upload_discouragement.menu_item", false)) {
            arrayList.add(new ToggleUploadDiscouragedLayerAction(this));
        }
        arrayList.addAll(Arrays.asList(new ConsistencyTestAction(), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public static GpxData toGpxData(DataSet dataSet, File file) {
        GpxData gpxData = new GpxData();
        gpxData.storageFile = file;
        HashSet<Node> hashSet = new HashSet<Node>();
        OsmDataLayer.waysToGpxData(dataSet.getWays(), gpxData, hashSet);
        OsmDataLayer.nodesToGpxData(dataSet.getNodes(), gpxData, hashSet);
        return gpxData;
    }

    private static void waysToGpxData(Collection<Way> collection, GpxData gpxData, Set<Node> set) {
        ArrayList<Way> arrayList = new ArrayList<Way>(collection);
        Collections.sort(arrayList, new OsmPrimitiveComparator(true, false));
        Collections.reverse(arrayList);
        for (Way way : arrayList) {
            if (!way.isUsable()) continue;
            ArrayList<Collection<WayPoint>> arrayList2 = new ArrayList<Collection<WayPoint>>();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (way.get("name") != null) {
                hashMap.put("name", way.get("name"));
            }
            ArrayList<WayPoint> arrayList3 = null;
            for (Node node : way.getNodes()) {
                if (!node.isUsable()) {
                    arrayList3 = null;
                    continue;
                }
                if (arrayList3 == null) {
                    arrayList3 = new ArrayList<WayPoint>();
                    arrayList2.add(arrayList3);
                }
                if (!node.isTagged()) {
                    set.add(node);
                }
                arrayList3.add(OsmDataLayer.nodeToWayPoint(node));
            }
            gpxData.tracks.add(new ImmutableGpxTrack(arrayList2, hashMap));
        }
    }

    private static WayPoint nodeToWayPoint(Node node) {
        WayPoint wayPoint = new WayPoint(node.getCoor());
        OsmDataLayer.addDoubleIfPresent(wayPoint, node, "ele", new String[0]);
        if (!node.isTimestampEmpty()) {
            wayPoint.put("time", DateUtils.fromTimestamp(node.getRawTimestamp()));
            wayPoint.setTime();
        }
        OsmDataLayer.addDoubleIfPresent(wayPoint, node, "magvar", new String[0]);
        OsmDataLayer.addDoubleIfPresent(wayPoint, node, "geoidheight", new String[0]);
        OsmDataLayer.addStringIfPresent(wayPoint, node, "name", new String[0]);
        OsmDataLayer.addStringIfPresent(wayPoint, node, "desc", "description");
        OsmDataLayer.addStringIfPresent(wayPoint, node, "cmt", "comment");
        OsmDataLayer.addStringIfPresent(wayPoint, node, "src", "source", "source:position");
        ArrayList<GpxLink> arrayList = new ArrayList<GpxLink>();
        for (String string : new String[]{"link", "url", "website", "contact:website"}) {
            String string2 = node.get(string);
            if (string2 == null) continue;
            arrayList.add(new GpxLink(string2));
        }
        wayPoint.put("meta.links", arrayList);
        OsmDataLayer.addStringIfPresent(wayPoint, node, "sym", "wpt_symbol");
        OsmDataLayer.addStringIfPresent(wayPoint, node, "type", new String[0]);
        OsmDataLayer.addStringIfPresent(wayPoint, node, "fix", "gps:fix");
        OsmDataLayer.addIntegerIfPresent(wayPoint, node, "sat", "gps:sat");
        OsmDataLayer.addDoubleIfPresent(wayPoint, node, "hdop", "gps:hdop");
        OsmDataLayer.addDoubleIfPresent(wayPoint, node, "vdop", "gps:vdop");
        OsmDataLayer.addDoubleIfPresent(wayPoint, node, "pdop", "gps:pdop");
        OsmDataLayer.addDoubleIfPresent(wayPoint, node, "ageofdgpsdata", "gps:ageofdgpsdata");
        OsmDataLayer.addIntegerIfPresent(wayPoint, node, "dgpsid", "gps:dgpsid");
        return wayPoint;
    }

    private static void nodesToGpxData(Collection<Node> collection, GpxData gpxData, Set<Node> set) {
        ArrayList<Node> arrayList = new ArrayList<Node>(collection);
        arrayList.removeAll(set);
        Collections.sort(arrayList);
        for (Node node : arrayList) {
            if (node.isIncomplete() || node.isDeleted()) continue;
            gpxData.waypoints.add(OsmDataLayer.nodeToWayPoint(node));
        }
    }

    private static void addIntegerIfPresent(WayPoint wayPoint, OsmPrimitive osmPrimitive, String string, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        arrayList.add(0, string);
        for (String string2 : arrayList) {
            String string3 = osmPrimitive.get(string2);
            if (string3 == null) continue;
            try {
                int n = Integer.parseInt(string3);
                if ("sat".equals(string) && n < 0 || "dgpsid".equals(string) && (0 > n || n > 1023)) continue;
                wayPoint.put(string, string3);
                break;
            }
            catch (NumberFormatException numberFormatException) {
                if (!Main.isTraceEnabled()) continue;
                Main.trace(numberFormatException.getMessage());
            }
        }
    }

    private static void addDoubleIfPresent(WayPoint wayPoint, OsmPrimitive osmPrimitive, String string, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        arrayList.add(0, string);
        for (String string2 : arrayList) {
            String string3 = osmPrimitive.get(string2);
            if (string3 == null) continue;
            try {
                double d = Double.parseDouble(string3);
                if ("magvar".equals(string) && (!(0.0 <= d) || !(d < 360.0))) continue;
                wayPoint.put(string, string3);
                break;
            }
            catch (NumberFormatException numberFormatException) {
                if (!Main.isTraceEnabled()) continue;
                Main.trace(numberFormatException.getMessage());
            }
        }
    }

    private static void addStringIfPresent(WayPoint wayPoint, OsmPrimitive osmPrimitive, String string, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        arrayList.add(0, string);
        for (String string2 : arrayList) {
            String string3 = osmPrimitive.get(string2);
            if (string3 == null || "fix".equals(string) && !GpxConstants.FIX_VALUES.contains(string3)) continue;
            wayPoint.put(string, string3);
            break;
        }
    }

    public GpxData toGpxData() {
        return OsmDataLayer.toGpxData(this.data, this.getAssociatedFile());
    }

    public boolean containsPoint(LatLon latLon) {
        if (this.data.dataSources.isEmpty()) {
            return true;
        }
        boolean bl = false;
        for (DataSource dataSource : this.data.dataSources) {
            if (!dataSource.bounds.contains(latLon)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }

    @Override
    public boolean requiresUploadToServer() {
        return this.requiresUploadToServer;
    }

    @Override
    public boolean requiresSaveToFile() {
        return this.getAssociatedFile() != null && this.requiresSaveToFile;
    }

    @Override
    public void onPostLoadFromFile() {
        this.setRequiresSaveToFile(false);
        this.setRequiresUploadToServer(this.isModified());
    }

    public void onPostDownloadFromServer() {
        this.setRequiresSaveToFile(true);
        this.setRequiresUploadToServer(this.isModified());
    }

    @Override
    public boolean isChanged() {
        return this.isChanged || this.highlightUpdateCount != this.data.getHighlightUpdateCount();
    }

    @Override
    public void onPostSaveToFile() {
        this.setRequiresSaveToFile(false);
        this.setRequiresUploadToServer(this.isModified());
    }

    @Override
    public void onPostUploadToServer() {
        this.setRequiresUploadToServer(this.isModified());
    }

    @Override
    public void destroy() {
        DataSet.removeSelectionListener(this);
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        this.isChanged = true;
        this.setRequiresSaveToFile(true);
        this.setRequiresUploadToServer(true);
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        this.isChanged = true;
    }

    @Override
    public void projectionChanged(Projection projection, Projection projection2) {
    }

    @Override
    public final boolean isUploadDiscouraged() {
        return this.data.isUploadDiscouraged();
    }

    public final void setUploadDiscouraged(boolean bl) {
        if (bl ^ this.isUploadDiscouraged()) {
            this.data.setUploadDiscouraged(bl);
            for (LayerStateChangeListener layerStateChangeListener : this.layerStateChangeListeners) {
                layerStateChangeListener.uploadDiscouragedChanged(this, bl);
            }
        }
    }

    @Override
    public final boolean isModified() {
        return this.data.isModified();
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public boolean checkSaveConditions() {
        if (this.isDataSetEmpty() && 1 != GuiHelper.runInEDTAndWaitAndReturn(new Callable<Integer>(){

            @Override
            public Integer call() {
                ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Empty document", new Object[0]), new String[]{I18n.tr("Save anyway", new Object[0]), I18n.tr("Cancel", new Object[0])});
                extendedDialog.setContent(I18n.tr("The document contains no data.", new Object[0]));
                extendedDialog.setButtonIcons(new String[]{"save", "cancel"});
                return extendedDialog.showDialog().getValue();
            }
        })) {
            return false;
        }
        ConflictCollection conflictCollection = this.getConflicts();
        return conflictCollection == null || conflictCollection.isEmpty() || 1 == GuiHelper.runInEDTAndWaitAndReturn(new Callable<Integer>(){

            @Override
            public Integer call() {
                ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Conflicts", new Object[0]), new String[]{I18n.tr("Reject Conflicts and Save", new Object[0]), I18n.tr("Cancel", new Object[0])});
                extendedDialog.setContent(I18n.tr("There are unresolved conflicts. Conflicts will not be saved and handled as if you rejected all. Continue?", new Object[0]));
                extendedDialog.setButtonIcons(new String[]{"save", "cancel"});
                return extendedDialog.showDialog().getValue();
            }
        });
    }

    private boolean isDataSetEmpty() {
        if (this.data != null) {
            for (OsmPrimitive osmPrimitive : this.data.allNonDeletedPrimitives()) {
                if (osmPrimitive.isDeleted() && osmPrimitive.isNewOrUndeleted()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save OSM file", new Object[0]), "osm");
    }

    @Override
    public AbstractIOTask createUploadTask(ProgressMonitor progressMonitor) {
        UploadDialog uploadDialog = UploadDialog.getUploadDialog();
        return new UploadLayerTask(uploadDialog.getUploadStrategySpecification(), this, progressMonitor, uploadDialog.getChangeset());
    }

    @Override
    public AbstractUploadDialog getUploadDialog() {
        UploadDialog uploadDialog = UploadDialog.getUploadDialog();
        uploadDialog.setUploadedPrimitives(new APIDataSet(this.data));
        return uploadDialog;
    }

    static {
        OsmDataLayer.createHatchTexture();
    }

    private class ConsistencyTestAction
    extends AbstractAction {
        ConsistencyTestAction() {
            super(I18n.tr("Dataset consistency test", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = DatasetConsistencyTest.runTests(OsmDataLayer.this.data);
            if (string.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("No problems found", new Object[0]));
            } else {
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.add((Component)new JLabel(I18n.tr("Following problems found:", new Object[0])), GBC.eol());
                JosmTextArea josmTextArea = new JosmTextArea(string, 20, 60);
                josmTextArea.setCaretPosition(0);
                josmTextArea.setEditable(false);
                jPanel.add((Component)new JScrollPane(josmTextArea), GBC.eop());
                JOptionPane.showMessageDialog(Main.parent, jPanel, I18n.tr("Warning", new Object[0]), 2);
            }
        }
    }

    public class ConvertToGpxLayerAction
    extends AbstractAction {
        public ConvertToGpxLayerAction() {
            super(I18n.tr("Convert to GPX layer", new Object[0]), ImageProvider.get("converttogpx"));
            this.putValue("help", HelpUtil.ht("/Action/ConvertToGpxLayer"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GpxData gpxData = OsmDataLayer.this.toGpxData();
            GpxLayer gpxLayer = new GpxLayer(gpxData, I18n.tr("Converted from: {0}", OsmDataLayer.this.getName()));
            String string = OsmDataLayer.this.getAssociatedFile().getName().replaceAll(Pattern.quote(".gpx.osm") + "$", "") + ".gpx";
            gpxLayer.setAssociatedFile(new File(OsmDataLayer.this.getAssociatedFile().getParentFile(), string));
            Main.main.addLayer(gpxLayer);
            if (Main.pref.getBoolean("marker.makeautomarkers", true) && !gpxData.waypoints.isEmpty()) {
                Main.main.addLayer(new MarkerLayer(gpxData, I18n.tr("Converted from: {0}", OsmDataLayer.this.getName()), null, gpxLayer));
            }
            Main.main.removeLayer(OsmDataLayer.this);
        }
    }

    public static interface LayerStateChangeListener {
        public void uploadDiscouragedChanged(OsmDataLayer var1, boolean var2);
    }

    public static interface CommandQueueListener {
        public void commandChanged(int var1, int var2);
    }

    public static final class DataCountVisitor
    extends AbstractVisitor {
        public int nodes;
        public int ways;
        public int relations;
        public int deletedNodes;
        public int deletedWays;
        public int deletedRelations;

        @Override
        public void visit(Node node) {
            ++this.nodes;
            if (node.isDeleted()) {
                ++this.deletedNodes;
            }
        }

        @Override
        public void visit(Way way) {
            ++this.ways;
            if (way.isDeleted()) {
                ++this.deletedWays;
            }
        }

        @Override
        public void visit(Relation relation) {
            ++this.relations;
            if (relation.isDeleted()) {
                ++this.deletedRelations;
            }
        }
    }
}

