/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.Date;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractParser
extends DefaultHandler {
    protected HistoryOsmPrimitive currentPrimitive;
    protected Locator locator;

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    protected abstract void throwException(String var1) throws SAXException;

    protected abstract void throwException(String var1, Exception var2) throws SAXException;

    protected final long getMandatoryAttributeLong(Attributes attributes, String string) throws SAXException {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", string));
        }
        long l = 0L;
        try {
            l = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long. Got ''{1}''.", string, string2), numberFormatException);
        }
        if (l < 0L) {
            this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long (>=0). Got ''{1}''.", string, string2));
        }
        return l;
    }

    protected final Long getAttributeLong(Attributes attributes, String string) throws SAXException {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return null;
        }
        Long l = 0L;
        try {
            l = Long.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long. Got ''{1}''.", string, string2), numberFormatException);
        }
        if (l < 0L) {
            this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long (>=0). Got ''{1}''.", string, string2));
        }
        return l;
    }

    protected final Double getAttributeDouble(Attributes attributes, String string) throws SAXException {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return null;
        }
        double d = 0.0;
        try {
            d = Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.throwException(I18n.tr("Illegal value for attribute ''{0}'' of type double. Got ''{1}''.", string, string2), numberFormatException);
        }
        return d;
    }

    protected final String getMandatoryAttributeString(Attributes attributes, String string) throws SAXException {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", string));
        }
        return string2;
    }

    protected boolean getMandatoryAttributeBoolean(Attributes attributes, String string) throws SAXException {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", string));
        }
        if ("true".equals(string2)) {
            return true;
        }
        if ("false".equals(string2)) {
            return false;
        }
        this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type boolean. Got ''{1}''.", string, string2));
        return false;
    }

    protected final HistoryOsmPrimitive createPrimitive(Attributes attributes, OsmPrimitiveType osmPrimitiveType) throws SAXException {
        long l = this.getMandatoryAttributeLong(attributes, "id");
        long l2 = this.getMandatoryAttributeLong(attributes, "version");
        long l3 = this.getMandatoryAttributeLong(attributes, "changeset");
        boolean bl = this.getMandatoryAttributeBoolean(attributes, "visible");
        Long l4 = this.getAttributeLong(attributes, "uid");
        String string = attributes.getValue("user");
        User user = string != null ? (l4 != null ? User.createOsmUser(l4, string) : User.createLocalUser(string)) : User.getAnonymous();
        String string2 = this.getMandatoryAttributeString(attributes, "timestamp");
        Date date = DateUtils.fromString(string2);
        HistoryOsmPrimitive historyOsmPrimitive = null;
        if (osmPrimitiveType.equals((Object)OsmPrimitiveType.NODE)) {
            Double d = this.getAttributeDouble(attributes, "lat");
            Double d2 = this.getAttributeDouble(attributes, "lon");
            LatLon latLon = d != null && d2 != null ? new LatLon(d, d2) : null;
            historyOsmPrimitive = new HistoryNode(l, l2, bl, user, l3, date, latLon);
        } else if (osmPrimitiveType.equals((Object)OsmPrimitiveType.WAY)) {
            historyOsmPrimitive = new HistoryWay(l, l2, bl, user, l3, date);
        } else if (osmPrimitiveType.equals((Object)OsmPrimitiveType.RELATION)) {
            historyOsmPrimitive = new HistoryRelation(l, l2, bl, user, l3, date);
        }
        return historyOsmPrimitive;
    }

    protected final void startNode(Attributes attributes) throws SAXException {
        this.currentPrimitive = this.createPrimitive(attributes, OsmPrimitiveType.NODE);
    }

    protected final void startWay(Attributes attributes) throws SAXException {
        this.currentPrimitive = this.createPrimitive(attributes, OsmPrimitiveType.WAY);
    }

    protected final void startRelation(Attributes attributes) throws SAXException {
        this.currentPrimitive = this.createPrimitive(attributes, OsmPrimitiveType.RELATION);
    }

    protected final void handleTag(Attributes attributes) throws SAXException {
        String string = this.getMandatoryAttributeString(attributes, "k");
        String string2 = this.getMandatoryAttributeString(attributes, "v");
        this.currentPrimitive.put(string, string2);
    }

    protected final void handleNodeReference(Attributes attributes) throws SAXException {
        long l = this.getMandatoryAttributeLong(attributes, "ref");
        ((HistoryWay)this.currentPrimitive).addNode(l);
    }

    protected void handleMember(Attributes attributes) throws SAXException {
        long l = this.getMandatoryAttributeLong(attributes, "ref");
        String string = this.getMandatoryAttributeString(attributes, "type");
        OsmPrimitiveType osmPrimitiveType = null;
        try {
            osmPrimitiveType = OsmPrimitiveType.fromApiTypeName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type OsmPrimitiveType. Got ''{1}''.", "type", string), illegalArgumentException);
        }
        String string2 = this.getMandatoryAttributeString(attributes, "role");
        RelationMemberData relationMemberData = new RelationMemberData(string2, osmPrimitiveType, l);
        ((HistoryRelation)this.currentPrimitive).addMember(relationMemberData);
    }

    protected final boolean doStartElement(String string, Attributes attributes) throws SAXException {
        switch (string) {
            case "node": {
                this.startNode(attributes);
                return true;
            }
            case "way": {
                this.startWay(attributes);
                return true;
            }
            case "relation": {
                this.startRelation(attributes);
                return true;
            }
            case "tag": {
                this.handleTag(attributes);
                return true;
            }
            case "nd": {
                this.handleNodeReference(attributes);
                return true;
            }
            case "member": {
                this.handleMember(attributes);
                return true;
            }
        }
        return false;
    }
}

