/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.locals;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeGen;
import org.jruby.truffle.nodes.locals.FlipFlopStateNode;
import org.jruby.truffle.runtime.RubyContext;

public class FlipFlopNode
extends RubyNode {
    @Node.Child
    private BooleanCastNode begin;
    @Node.Child
    private BooleanCastNode end;
    @Node.Child
    private FlipFlopStateNode stateNode;
    private final boolean exclusive;

    public FlipFlopNode(RubyContext context, SourceSection sourceSection, RubyNode begin, RubyNode end, FlipFlopStateNode stateNode, boolean exclusive) {
        super(context, sourceSection);
        this.begin = BooleanCastNodeGen.create(context, sourceSection, begin);
        this.end = BooleanCastNodeGen.create(context, sourceSection, end);
        this.stateNode = stateNode;
        this.exclusive = exclusive;
    }

    @Override
    public boolean executeBoolean(VirtualFrame frame) {
        if (this.exclusive) {
            if (this.stateNode.getState(frame)) {
                if (this.end.executeBoolean(frame)) {
                    this.stateNode.setState(frame, false);
                }
                return true;
            }
            boolean newState = this.begin.executeBoolean(frame);
            this.stateNode.setState(frame, newState);
            return newState;
        }
        if (this.stateNode.getState(frame)) {
            if (this.end.executeBoolean(frame)) {
                this.stateNode.setState(frame, false);
            }
            return true;
        }
        if (this.begin.executeBoolean(frame)) {
            this.stateNode.setState(frame, !this.end.executeBoolean(frame));
            return true;
        }
        return false;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeBoolean(frame);
    }
}

