/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font.type3;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.GraphicsState;
import de.intarsys.pdf.content.TextState;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.font.PDFontType3;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformGlyphs;
import de.intarsys.pdf.platform.cwt.font.type3.Type3Font;
import de.intarsys.pdf.platform.cwt.rendering.ICSPlatformDevice;

public class Type3Glyphs
implements IPlatformGlyphs {
    private final Type3Font font;
    private final PDFontType3 pdFont;
    private final PDGlyphs glyphs;

    protected Type3Glyphs(Type3Font type3Font, PDGlyphs pDGlyphs) {
        this.font = type3Font;
        this.pdFont = (PDFontType3)type3Font.getPDFont();
        this.glyphs = pDGlyphs;
    }

    @Override
    public PDGlyphs getGlyphs() {
        return this.glyphs;
    }

    @Override
    public IPlatformFont getPlatformFont() {
        return this.font;
    }

    @Override
    public int getWidth() {
        return 0;
    }

    @Override
    public void render(ICSPlatformDevice iCSPlatformDevice) {
        GraphicsState graphicsState = iCSPlatformDevice.getGraphicsState();
        COSDictionary cOSDictionary = this.pdFont.cosGetCharProcs();
        String string = this.pdFont.getEncoding().getGlyphName(this.glyphs.getCodepoint());
        if (string == null) {
            return;
        }
        COSStream cOSStream = cOSDictionary.get(COSName.create((String)string)).asStream();
        if (cOSStream == null) {
            return;
        }
        CSContent cSContent = CSContent.createFromCos((COSStream)cOSStream);
        iCSPlatformDevice.saveState();
        try {
            TextState textState = graphicsState.textState;
            iCSPlatformDevice.transform(textState.fontSize * textState.derivedHorizontalScalingFactor, 0.0f, 0.0f, textState.fontSize, 0.0f, 0.0f);
            CDSMatrix cDSMatrix = this.pdFont.getFontMatrix();
            if (cDSMatrix != null) {
                iCSPlatformDevice.transform(cDSMatrix.getA(), cDSMatrix.getB(), cDSMatrix.getC(), cDSMatrix.getD(), cDSMatrix.getE(), cDSMatrix.getF());
            }
            iCSPlatformDevice.getInterpreter().process(cSContent, this.pdFont.getResources());
        }
        finally {
            iCSPlatformDevice.restoreState();
        }
    }
}

