/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.parser.validators;

import java.io.File;
import jcmdline.CmdLineHandler;
import jcmdline.FileParam;
import jcmdline.PdfFileParam;
import jcmdline.StringParam;
import jcmdline.dto.PdfFile;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.DocumentInfoParsedCommand;
import org.pdfsam.console.business.parser.validators.interfaces.AbstractCmdValidator;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.exceptions.console.ParseException;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.console.utils.ValidationUtility;

public class DocumentInfoCmdValidator
extends AbstractCmdValidator {
    protected AbstractParsedCommand validateArguments(CmdLineHandler cmdLineHandler) throws ConsoleException {
        DocumentInfoParsedCommand parsedCommandDTO = new DocumentInfoParsedCommand();
        if (cmdLineHandler != null) {
            StringParam keywordsOption;
            StringParam subjectOption;
            StringParam titleOption;
            FileParam oOption = (FileParam)cmdLineHandler.getOption("o");
            if (!oOption.isSet()) {
                throw new ParseException(15);
            }
            File outFile = oOption.getFile();
            ValidationUtility.assertValidPdfExtension(outFile.getName());
            parsedCommandDTO.setOutputFile(outFile);
            PdfFileParam fOption = (PdfFileParam)cmdLineHandler.getOption("f");
            if (!fOption.isSet()) {
                throw new ParseException(20);
            }
            PdfFile inputFile = fOption.getPdfFile();
            ValidationUtility.assertValidPdfExtension(inputFile.getFile().getName());
            parsedCommandDTO.setInputFile(FileUtility.getPdfFile(inputFile));
            StringParam authorOption = (StringParam)cmdLineHandler.getOption("author");
            if (authorOption.isSet()) {
                parsedCommandDTO.setAuthor(authorOption.getValue());
            }
            if ((titleOption = (StringParam)cmdLineHandler.getOption("title")).isSet()) {
                parsedCommandDTO.setTitle(titleOption.getValue());
            }
            if ((subjectOption = (StringParam)cmdLineHandler.getOption("subject")).isSet()) {
                parsedCommandDTO.setSubject(subjectOption.getValue());
            }
            if ((keywordsOption = (StringParam)cmdLineHandler.getOption("keywords")).isSet()) {
                parsedCommandDTO.setKeywords(keywordsOption.getValue());
            }
        } else {
            throw new ConsoleException(2);
        }
        return parsedCommandDTO;
    }
}

