/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.pdf;

import java.util.Observable;
import java.util.Observer;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.pdf.handlers.AlternateMixCmdExecutor;
import org.pdfsam.console.business.pdf.handlers.ConcatCmdExecutor;
import org.pdfsam.console.business.pdf.handlers.DecryptCmdExecutor;
import org.pdfsam.console.business.pdf.handlers.DocumentInfoCmdExecutor;
import org.pdfsam.console.business.pdf.handlers.EncryptCmdExecutor;
import org.pdfsam.console.business.pdf.handlers.PageLabelsCmdExecutor;
import org.pdfsam.console.business.pdf.handlers.RotateCmdExecutor;
import org.pdfsam.console.business.pdf.handlers.SetViewerCmdExecutor;
import org.pdfsam.console.business.pdf.handlers.SlideShowCmdExecutor;
import org.pdfsam.console.business.pdf.handlers.SplitCmdExecutor;
import org.pdfsam.console.business.pdf.handlers.UnpackCmdExecutor;
import org.pdfsam.console.business.pdf.handlers.interfaces.AbstractCmdExecutor;
import org.pdfsam.console.exceptions.console.ConsoleException;

public class CmdExecuteManager
extends Observable
implements Observer {
    private final Logger LOG = Logger.getLogger(CmdExecuteManager.class.getPackage().getName());
    private AbstractCmdExecutor cmdExecutor = null;
    private final StopWatch stopWatch = new StopWatch();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AbstractParsedCommand parsedCommand) throws ConsoleException {
        block5: {
            this.stopWatch.reset();
            this.stopWatch.start();
            try {
                if (parsedCommand != null) {
                    this.cmdExecutor = this.getExecutor(parsedCommand);
                    if (this.cmdExecutor != null) {
                        this.cmdExecutor.addObserver(this);
                        this.cmdExecutor.execute(parsedCommand);
                        this.LOG.info("Command '" + parsedCommand.getCommand() + "' executed in " + DurationFormatUtils.formatDurationWords((long)this.stopWatch.getTime(), (boolean)true, (boolean)true));
                        break block5;
                    }
                    throw new ConsoleException(6, new String[]{"" + parsedCommand.getCommand()});
                }
                throw new ConsoleException(7);
            }
            finally {
                this.stopWatch.stop();
                this.cleanExecutor();
            }
        }
    }

    private void cleanExecutor() {
        if (this.cmdExecutor != null) {
            try {
                this.cmdExecutor.clean();
            }
            catch (Exception e) {
                this.LOG.warn("Error cleaning the command executor: " + e.getMessage());
            }
        }
        this.cmdExecutor = null;
    }

    public void update(Observable arg0, Object arg1) {
        this.setChanged();
        this.notifyObservers(arg1);
    }

    private AbstractCmdExecutor getExecutor(AbstractParsedCommand parsedCommand) {
        AbstractCmdExecutor retVal = "mix".equals(parsedCommand.getCommand()) ? new AlternateMixCmdExecutor() : ("split".equals(parsedCommand.getCommand()) ? new SplitCmdExecutor() : ("encrypt".equals(parsedCommand.getCommand()) ? new EncryptCmdExecutor() : ("concat".equals(parsedCommand.getCommand()) ? new ConcatCmdExecutor() : ("unpack".equals(parsedCommand.getCommand()) ? new UnpackCmdExecutor() : ("setviewer".equals(parsedCommand.getCommand()) ? new SetViewerCmdExecutor() : ("slideshow".equals(parsedCommand.getCommand()) ? new SlideShowCmdExecutor() : ("decrypt".equals(parsedCommand.getCommand()) ? new DecryptCmdExecutor() : ("rotate".equals(parsedCommand.getCommand()) ? new RotateCmdExecutor() : ("pagelabels".equals(parsedCommand.getCommand()) ? new PageLabelsCmdExecutor() : ("setdocinfo".equals(parsedCommand.getCommand()) ? new DocumentInfoCmdExecutor() : null))))))))));
        return retVal;
    }
}

