/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.tag;

import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.tag.ITagSupport;
import de.intarsys.tools.tag.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class TagTools {
    private static final Attribute ATTR_TAGS = new Attribute("tags");
    private static final Tag[] EMPTY = new Tag[0];
    private static final Map<Object, List<Tag>> tagsMap = new WeakHashMap<Object, List<Tag>>();

    public static void addTag(Object object, String string, String string2) {
        List<Tag> list = TagTools.basicGetTags(object);
        list.add(new Tag(string, string2));
    }

    public static void addTag(Object object, Tag tag) {
        if (tag == null) {
            return;
        }
        List<Tag> list = TagTools.basicGetTags(object);
        list.add(tag);
    }

    public static void addTags(Object object, List<Tag> list) {
        if (list == null) {
            return;
        }
        List<Tag> list2 = TagTools.basicGetTags(object);
        list2.addAll(list);
    }

    public static void addTags(Object object, Map<String, String> map) {
        if (map == null) {
            return;
        }
        List<Tag> list = TagTools.basicGetTags(object);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            list.add(new Tag(entry.getKey(), entry.getValue()));
        }
    }

    public static void addTags(Object object, String string) {
        List<Tag> list = TagTools.basicGetTags(object);
        list.addAll(Arrays.asList(Tag.create(string)));
    }

    public static void addTags(Object object, Tag[] tagArray) {
        if (tagArray == null) {
            return;
        }
        List<Tag> list = TagTools.basicGetTags(object);
        list.addAll(Arrays.asList(tagArray));
    }

    protected static List<Tag> basicGetTags(Object object) {
        if (object instanceof ITagSupport) {
            return ((ITagSupport)object).getTags();
        }
        if (object instanceof IAttributeSupport) {
            ArrayList arrayList = (ArrayList)((IAttributeSupport)object).getAttribute(ATTR_TAGS);
            if (arrayList == null) {
                arrayList = new ArrayList();
                ((IAttributeSupport)object).setAttribute(ATTR_TAGS, arrayList);
            }
            return arrayList;
        }
        List<Tag> list = tagsMap.get(object);
        if (list == null) {
            list = new ArrayList<Tag>();
            tagsMap.put(object, list);
        }
        return list;
    }

    protected static List<Tag> basicLookupTags(Object object) {
        if (object instanceof ITagSupport) {
            return ((ITagSupport)object).getTags();
        }
        if (object instanceof IAttributeSupport) {
            List list = (List)((IAttributeSupport)object).getAttribute(ATTR_TAGS);
            return list;
        }
        List<Tag> list = tagsMap.get(object);
        return list;
    }

    public static Tag getTag(Object object, String string) {
        List<Tag> list = TagTools.basicLookupTags(object);
        if (list == null) {
            return null;
        }
        for (Tag tag : list) {
            if (!string.equals(tag.getKey())) continue;
            return tag;
        }
        return null;
    }

    public static Tag[] getTags(Object object) {
        List<Tag> list = TagTools.basicLookupTags(object);
        if (list == null) {
            return EMPTY;
        }
        return list.toArray(new Tag[list.size()]);
    }

    public static Tag[] getTags(Object object, String string) {
        List<Tag> list = TagTools.basicLookupTags(object);
        if (list == null) {
            return EMPTY;
        }
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        for (Tag tag : list) {
            if (!string.equals(tag.getKey())) continue;
            arrayList.add(tag);
        }
        return arrayList.toArray(new Tag[arrayList.size()]);
    }

    public static String getTagValue(Object object, String string) {
        Tag tag = TagTools.getTag(object, string);
        if (tag == null) {
            return null;
        }
        return tag.getValue();
    }

    public static String[] getTagValues(Object object) {
        Tag[] tagArray = TagTools.getTags(object);
        String[] stringArray = new String[tagArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = tagArray[n].getValue();
            ++n;
        }
        return stringArray;
    }

    public static String[] getTagValues(Object object, String string) {
        Tag[] tagArray = TagTools.getTags(object, string);
        String[] stringArray = new String[tagArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = tagArray[n].getValue();
            ++n;
        }
        return stringArray;
    }

    public static boolean hasTag(Object object, String string) {
        List<Tag> list = TagTools.basicLookupTags(object);
        if (list == null) {
            return false;
        }
        for (Tag tag : list) {
            if (!string.equals(tag.getKey())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTags(Object object) {
        List<Tag> list = TagTools.basicLookupTags(object);
        if (list == null) {
            return false;
        }
        return !list.isEmpty();
    }

    public static void removeTags(Object object, String string) {
        List<Tag> list = TagTools.basicLookupTags(object);
        if (list == null) {
            return;
        }
        Iterator<Tag> iterator = list.iterator();
        while (iterator.hasNext()) {
            Tag tag = iterator.next();
            if (!string.equals(tag.getKey())) continue;
            iterator.remove();
        }
    }

    public static void setTag(Object object, String string, String string2) {
        TagTools.removeTags(object, string);
        List<Tag> list = TagTools.basicGetTags(object);
        list.add(new Tag(string, string2));
    }
}

