/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.business;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.commons.business.listeners.CleanClosedTabbedPanelListener;
import org.pdfsam.guiclient.commons.dnd.handlers.ClosableTabTransferHandler;
import org.pdfsam.guiclient.commons.panels.CloseableTabbedPane;
import org.pdfsam.guiclient.commons.panels.JVisualPdfPageSelectionPanel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.exceptions.ThumbnailCreationException;
import org.pdfsam.guiclient.utils.filters.PdfFilter;
import org.pdfsam.i18n.GettextResource;

public class ClosableTabbedPanelAdder {
    private static final Logger log = Logger.getLogger(ClosableTabbedPanelAdder.class.getPackage().getName());
    private CloseableTabbedPane inputTabbedPanel;
    private PropertyChangeListener outputPathPropertyChangeListener = null;

    public ClosableTabbedPanelAdder(CloseableTabbedPane inputTabbedPanel) {
        this.inputTabbedPanel = inputTabbedPanel;
        this.outputPathPropertyChangeListener = null;
    }

    public ClosableTabbedPanelAdder(CloseableTabbedPane inputTabbedPanel, PropertyChangeListener outputPathPropertyChangeListener) {
        this.inputTabbedPanel = inputTabbedPanel;
        this.outputPathPropertyChangeListener = outputPathPropertyChangeListener;
    }

    public void addTabs(List<File> fileList) {
        if (fileList != null && fileList.size() > 0) {
            this.addTabs(fileList.toArray(new File[fileList.size()]));
        }
    }

    public void addTabs(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            this.addTab(files[i]);
        }
    }

    public void addTab(File file, String password) {
        try {
            if (file != null && file.exists() && new PdfFilter(false).accept(file)) {
                JVisualPdfPageSelectionPanel inputPanel = new JVisualPdfPageSelectionPanel(1, true, false, false, 0, 0, 2);
                inputPanel.getThumbnailList().setTransferHandler(new ClosableTabTransferHandler(this));
                if (this.outputPathPropertyChangeListener != null) {
                    inputPanel.enableSetOutputPathMenuItem();
                    inputPanel.addPropertyChangeListener(this.outputPathPropertyChangeListener);
                }
                inputPanel.setSelectedPdfDocument(file);
                inputPanel.getPdfLoader().addFile(file, password);
                String panelName = file.getName();
                if (panelName.length() > 16) {
                    panelName = file.getName().substring(0, 14) + "..";
                }
                this.inputTabbedPanel.addTab(panelName, inputPanel, null, file.getName());
                this.inputTabbedPanel.addCloseableTabbedPaneListener(new CleanClosedTabbedPanelListener(this.inputTabbedPanel));
            }
        }
        catch (ThumbnailCreationException tce) {
            log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error: "), tce);
        }
    }

    public void addTab(File file) {
        this.addTab(file, null);
    }

    public PropertyChangeListener getOutputPathPropertyChangeListener() {
        return this.outputPathPropertyChangeListener;
    }

    public void setOutputPathPropertyChangeListener(PropertyChangeListener outputPathPropertyChangeListener) {
        this.outputPathPropertyChangeListener = outputPathPropertyChangeListener;
    }
}

