/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.StringItem;
import org.pdfsam.i18n.GettextResource;

public class PdfVersionUtility {
    private static final Logger log = Logger.getLogger(PdfVersionUtility.class.getPackage().getName());
    private static HashMap<String, String> cache = new HashMap();
    private static ArrayList<StringItem> listCache = new ArrayList();

    public static String getVersionDescription(char c) {
        String retVal = "";
        try {
            String description = PdfVersionUtility.getVersions().get(Character.toString(c));
            retVal = description != null ? description : "";
        }
        catch (Exception e) {
            log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error getting pdf version description."), e);
        }
        return retVal;
    }

    public static HashMap<String, String> getVersions() {
        if (cache.isEmpty()) {
            Configuration config = Configuration.getInstance();
            cache.put(Character.toString('2'), GettextResource.gettext((ResourceBundle)config.getI18nResourceBundle(), (String)"Version 1.2 (Acrobat 3)"));
            cache.put(Character.toString('3'), GettextResource.gettext((ResourceBundle)config.getI18nResourceBundle(), (String)"Version 1.3 (Acrobat 4)"));
            cache.put(Character.toString('4'), GettextResource.gettext((ResourceBundle)config.getI18nResourceBundle(), (String)"Version 1.4 (Acrobat 5)"));
            cache.put(Character.toString('5'), GettextResource.gettext((ResourceBundle)config.getI18nResourceBundle(), (String)"Version 1.5 (Acrobat 6)"));
            cache.put(Character.toString('6'), GettextResource.gettext((ResourceBundle)config.getI18nResourceBundle(), (String)"Version 1.6 (Acrobat 7)"));
            cache.put(Character.toString('7'), GettextResource.gettext((ResourceBundle)config.getI18nResourceBundle(), (String)"Version 1.7 (Acrobat 8)"));
        }
        return cache;
    }

    public static ArrayList<StringItem> getVersionsList() {
        if (listCache.isEmpty()) {
            Configuration config = Configuration.getInstance();
            listCache.add(new StringItem(Character.toString('2'), GettextResource.gettext((ResourceBundle)config.getI18nResourceBundle(), (String)"Version 1.2 (Acrobat 3)")));
            listCache.add(new StringItem(Character.toString('3'), GettextResource.gettext((ResourceBundle)config.getI18nResourceBundle(), (String)"Version 1.3 (Acrobat 4)")));
            listCache.add(new StringItem(Character.toString('4'), GettextResource.gettext((ResourceBundle)config.getI18nResourceBundle(), (String)"Version 1.4 (Acrobat 5)")));
            listCache.add(new StringItem(Character.toString('5'), GettextResource.gettext((ResourceBundle)config.getI18nResourceBundle(), (String)"Version 1.5 (Acrobat 6)")));
            listCache.add(new StringItem(Character.toString('6'), GettextResource.gettext((ResourceBundle)config.getI18nResourceBundle(), (String)"Version 1.6 (Acrobat 7)")));
            listCache.add(new StringItem(Character.toString('7'), GettextResource.gettext((ResourceBundle)config.getI18nResourceBundle(), (String)"Version 1.7 (Acrobat 8)")));
        }
        return listCache;
    }
}

