/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDEmbeddedFile;
import de.intarsys.pdf.pd.PDFileSpecificationURL;
import de.intarsys.pdf.pd.PDObject;

public class PDFileSpecification
extends PDObject {
    public static final COSName CN_Type_Filespec = COSName.constant("Filespec");
    public static final COSName CN_Type_Alt_Filespec = COSName.constant("F");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_FS = COSName.constant("FS");
    public static final COSName DK_F = COSName.constant("F");
    public static final COSName DK_UF = COSName.constant("UF");
    public static final COSName CN_F_DOS = COSName.constant("DOS");
    public static final COSName CN_F_Mac = COSName.constant("Mac");
    public static final COSName CN_F_Unix = COSName.constant("Unix");
    public static final COSName CN_FS_URL = COSName.constant("URL");
    public static final COSName DK_EF = COSName.constant("EF");
    public static final COSName DK_RF = COSName.constant("RF");
    public static final COSName DK_Desc = COSName.constant("Desc");
    private COSName fileSystem = null;

    protected PDFileSpecification(COSObject cOSObject) {
        super(cOSObject);
    }

    @Override
    protected COSName cosGetExpectedType() {
        return CN_Type_Filespec;
    }

    public String getDescription() {
        COSString cOSString = this.cosGetField(DK_Desc).asString();
        if (cOSString == null) {
            return null;
        }
        return cOSString.stringValue();
    }

    public PDEmbeddedFile getEmbeddedFile(COSName cOSName) {
        COSDictionary cOSDictionary = this.getEmbeddedFiles();
        if (cOSDictionary == null) {
            return null;
        }
        return (PDEmbeddedFile)PDEmbeddedFile.META.createFromCos(cOSDictionary.get(cOSName));
    }

    public COSDictionary getEmbeddedFiles() {
        return this.cosGetField(DK_EF).asDictionary();
    }

    public String getFile() {
        COSString cOSString = this.cosGetField(DK_F).asString();
        if (cOSString == null) {
            return null;
        }
        return cOSString.stringValue();
    }

    public String getFileSpecificationString(COSName cOSName) {
        return this.cosGetField(cOSName).stringValue();
    }

    public COSName getFileSystem() {
        return this.fileSystem;
    }

    @Override
    protected void initializeFromCos() {
        super.initializeFromCos();
    }

    @Override
    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.cosSetField(DK_FS, this.getFileSystem());
    }

    public void setDescription(String string) {
        this.setFieldString(DK_Desc, string);
    }

    public void setEmbeddedFile(COSName cOSName, PDEmbeddedFile pDEmbeddedFile) {
        COSDictionary cOSDictionary = this.getEmbeddedFiles();
        if (cOSDictionary == null) {
            cOSDictionary = COSDictionary.create();
            this.cosSetField(DK_EF, cOSDictionary);
        }
        cOSDictionary.put(cOSName, pDEmbeddedFile.cosGetObject());
    }

    public void setFile(String string) {
        this.setFieldString(DK_F, string);
    }

    public void setFileSpecificationString(COSName cOSName, String string) {
        this.setFieldString(cOSName, string);
    }

    public void setFileSystem(COSName cOSName) {
        this.fileSystem = cOSName;
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDFileSpecification(cOSObject);
        }

        @Override
        protected COSBasedObject.MetaClass doDetermineClass(COSObject cOSObject) {
            COSName cOSName = ((COSDictionary)cOSObject).get(DK_FS).asName();
            if (CN_FS_URL.equals(cOSName)) {
                return PDFileSpecificationURL.META;
            }
            return META;
        }

        @Override
        public Class getRootClass() {
            return PDFileSpecification.class;
        }
    }
}

