/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefSection;
import java.util.ArrayList;
import java.util.List;

public class STXRefSubsection {
    private STXRefSubsection next;
    private List entries;
    private int start;
    private int size;
    private STXRefSection xRefSection;

    protected STXRefSubsection(int n) {
        this(null, n);
    }

    public STXRefSubsection(STXRefSection sTXRefSection, int n) {
        this.xRefSection = sTXRefSection;
        this.start = n;
        this.entries = new ArrayList();
        this.size = 0;
    }

    protected void addEntry(STXRefEntry sTXRefEntry) {
        int n = sTXRefEntry.getObjectNumber();
        if (n < this.getStart()) {
            throw new IllegalArgumentException("can't add object with number " + n);
        }
        int n2 = this.start + this.size;
        if (this.start <= n && n < n2) {
            this.entries.set(n - this.start, sTXRefEntry);
            return;
        }
        if (n == n2) {
            this.entries.add(sTXRefEntry);
            ++this.size;
            this.checkNext();
            return;
        }
        throw new IllegalArgumentException("can't add object with number " + n);
    }

    protected void checkNext() {
        if (this.getNext() == null) {
            return;
        }
        if (this.getSize() == 0) {
            this.start = this.getNext().getStart();
            this.mergeWithNext();
            return;
        }
        if (this.start + this.getSize() == this.getNext().getStart()) {
            this.mergeWithNext();
        }
    }

    protected List getEntries() {
        return this.entries;
    }

    protected STXRefEntry getEntry(int n) {
        return (STXRefEntry)this.entries.get(n - this.start);
    }

    protected STXRefSubsection getNext() {
        return this.next;
    }

    public int getSize() {
        return this.size;
    }

    public int getStart() {
        return this.start;
    }

    public int getStop() {
        return this.start + this.getSize();
    }

    protected STXRefSection getXRefSection() {
        return this.xRefSection;
    }

    protected boolean isInSection(int n) {
        return n >= this.start && n < this.start + this.getSize();
    }

    protected void mergeWithNext() {
        this.entries.addAll(this.getNext().getEntries());
        this.size = this.entries.size();
        this.setNext(this.getNext().getNext());
    }

    protected void setNext(STXRefSubsection sTXRefSubsection) {
        this.next = sTXRefSubsection;
    }

    protected void setXRefSection(STXRefSection sTXRefSection) {
        this.xRefSection = sTXRefSection;
    }
}

