/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.PieceOfFurniture;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.swing.HomeTransferableList;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.swing.VisualTransferHandler;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.FurnitureCatalogController;
import com.eteks.sweethome3d.viewcontroller.FurnitureController;
import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

public class FurnitureCatalogTransferHandler
extends VisualTransferHandler {
    private final ContentManager contentManager;
    private final FurnitureCatalogController catalogController;
    private final FurnitureController furnitureController;

    public FurnitureCatalogTransferHandler(ContentManager contentManager, FurnitureCatalogController furnitureCatalogController, FurnitureController furnitureController) {
        this.contentManager = contentManager;
        this.catalogController = furnitureCatalogController;
        this.furnitureController = furnitureController;
    }

    public int getSourceActions(JComponent jComponent) {
        return 1;
    }

    public Icon getVisualRepresentation(Transferable transferable) {
        try {
            Selectable selectable;
            List list;
            if (transferable.isDataFlavorSupported(HomeTransferableList.HOME_FLAVOR) && (list = (List)transferable.getTransferData(HomeTransferableList.HOME_FLAVOR)).size() == 1 && (selectable = (Selectable)list.get(0)) instanceof PieceOfFurniture) {
                return IconManager.getInstance().getIcon(((PieceOfFurniture)((Object)selectable)).getIcon(), 48, null);
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return super.getVisualRepresentation(transferable);
    }

    protected Transferable createTransferable(JComponent jComponent) {
        List<CatalogPieceOfFurniture> list = this.catalogController.getSelectedFurniture();
        if (!list.isEmpty()) {
            ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>(list.size());
            for (CatalogPieceOfFurniture catalogPieceOfFurniture : list) {
                arrayList.add(this.furnitureController.createHomePieceOfFurniture(catalogPieceOfFurniture));
            }
            return new HomeTransferableList(arrayList);
        }
        return null;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        return this.catalogController != null && Arrays.asList(dataFlavorArray).contains(DataFlavor.javaFileListFlavor);
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
            try {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                final ArrayList<String> arrayList = new ArrayList<String>();
                for (File file : list) {
                    String string = file.getAbsolutePath();
                    if (!this.contentManager.isAcceptable(string, ContentManager.ContentType.MODEL)) continue;
                    arrayList.add(string);
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        FurnitureCatalogTransferHandler.this.catalogController.dropFiles(arrayList);
                    }
                });
                return !arrayList.isEmpty();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                throw new RuntimeException("Can't import", unsupportedFlavorException);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Can't access to data", iOException);
            }
        }
        return false;
    }
}

