/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.codegen;

import org.antlr.v4.codegen.CodeGenerator;
import org.antlr.v4.codegen.Target;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.ast.GrammarAST;
import org.stringtemplate.v4.NumberRenderer;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.StringRenderer;
import org.stringtemplate.v4.misc.STMessage;

public class CSharpTarget
extends Target {
    public CSharpTarget(CodeGenerator gen) {
        super(gen, "CSharp");
        this.targetCharValueEscape[0] = "\\0";
        this.targetCharValueEscape[7] = "\\a";
        this.targetCharValueEscape[11] = "\\v";
    }

    @Override
    public String getVersion() {
        return "4.5";
    }

    @Override
    public String encodeIntAsCharEscape(int v) {
        if (v < 0 || v > 65535) {
            throw new IllegalArgumentException(String.format("Cannot encode the specified value: %d", v));
        }
        if (v >= 0 && v < this.targetCharValueEscape.length && this.targetCharValueEscape[v] != null) {
            return this.targetCharValueEscape[v];
        }
        if (!(v < 32 || v >= 127 || v >= 48 && v <= 57 || v >= 97 && v <= 102 || v >= 65 && v <= 70)) {
            return String.valueOf((char)v);
        }
        return String.format("\\x%X", v & 0xFFFF);
    }

    @Override
    public String getTargetStringLiteralFromANTLRStringLiteral(CodeGenerator generator, String literal, boolean addQuotes) {
        StringBuilder sb = new StringBuilder();
        String is = literal;
        if (addQuotes) {
            sb.append('\"');
        }
        for (int i = 1; i < is.length() - 1; ++i) {
            if (is.charAt(i) == '\\') {
                switch (is.charAt(i + 1)) {
                    case '\"': 
                    case '\\': 
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': {
                        sb.append('\\');
                        break;
                    }
                    case 'u': {
                        sb.append('\\');
                        sb.append('\\');
                        break;
                    }
                }
                ++i;
            } else if (is.charAt(i) == '\"') {
                sb.append('\\');
            }
            sb.append(is.charAt(i));
        }
        if (addQuotes) {
            sb.append('\"');
        }
        return sb.toString();
    }

    @Override
    protected boolean visibleGrammarSymbolCausesIssueInGeneratedCode(GrammarAST idNode) {
        return false;
    }

    @Override
    protected STGroup loadTemplates() {
        STGroupFile result = new STGroupFile("org/antlr/v4/tool/templates/codegen/CSharp/" + this.getLanguage() + STGroup.GROUP_FILE_EXTENSION);
        result.registerRenderer(Integer.class, new NumberRenderer());
        result.registerRenderer(String.class, new StringRenderer());
        result.setListener(new STErrorListener(){

            @Override
            public void compileTimeError(STMessage msg) {
                this.reportError(msg);
            }

            @Override
            public void runTimeError(STMessage msg) {
                this.reportError(msg);
            }

            @Override
            public void IOError(STMessage msg) {
                this.reportError(msg);
            }

            @Override
            public void internalError(STMessage msg) {
                this.reportError(msg);
            }

            private void reportError(STMessage msg) {
                CSharpTarget.this.getCodeGenerator().tool.errMgr.toolError(ErrorType.STRING_TEMPLATE_WARNING, msg.cause, msg.toString());
            }
        });
        return result;
    }
}

