/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.scala;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import org.gradle.language.scala.tasks.BaseScalaCompileOptions;

public class ScalaCompileOptions
extends BaseScalaCompileOptions {
    private static final ImmutableMap<String, String> FIELD_NAMES_TO_ANT_PROPERTIES = new ImmutableMap.Builder().put((Object)"loggingLevel", (Object)"logging").put((Object)"loggingPhases", (Object)"logphase").put((Object)"targetCompatibility", (Object)"target").put((Object)"optimize", (Object)"optimise").put((Object)"daemonServer", (Object)"server").put((Object)"listFiles", (Object)"scalacdebugging").put((Object)"debugLevel", (Object)"debuginfo").put((Object)"additionalParameters", (Object)"addparams").build();
    private boolean fork;
    private boolean useAnt = true;
    private boolean useCompileDaemon;
    private String daemonServer;

    public boolean isUseAnt() {
        return this.useAnt;
    }

    public void setUseAnt(boolean useAnt) {
        this.useAnt = useAnt;
        if (!useAnt) {
            this.setFork(true);
        }
    }

    public boolean isFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public boolean isUseCompileDaemon() {
        return this.useCompileDaemon;
    }

    public void setUseCompileDaemon(boolean useCompileDaemon) {
        this.useCompileDaemon = useCompileDaemon;
    }

    public String getDaemonServer() {
        return this.daemonServer;
    }

    public void setDaemonServer(String daemonServer) {
        this.daemonServer = daemonServer;
    }

    protected boolean excludeFromAntProperties(String fieldName) {
        return fieldName.equals("useCompileDaemon") || fieldName.equals("forkOptions") || fieldName.equals("useAnt") || fieldName.equals("incrementalOptions") || fieldName.equals("targetCompatibility") || fieldName.equals("optimize") && !this.isOptimize();
    }

    protected String getAntPropertyName(String fieldName) {
        if (FIELD_NAMES_TO_ANT_PROPERTIES.containsKey((Object)fieldName)) {
            return (String)FIELD_NAMES_TO_ANT_PROPERTIES.get((Object)fieldName);
        }
        return fieldName;
    }

    protected Object getAntPropertyValue(String fieldName, Object value) {
        if (fieldName.equals("deprecation")) {
            return this.toOnOffString(this.isDeprecation());
        }
        if (fieldName.equals("unchecked")) {
            return this.toOnOffString(this.isUnchecked());
        }
        if (fieldName.equals("optimize")) {
            return this.toOnOffString(this.isOptimize());
        }
        if (fieldName.equals("loggingPhases")) {
            return this.getLoggingPhases().isEmpty() ? " " : Joiner.on((char)',').join((Iterable)this.getLoggingPhases());
        }
        if (fieldName.equals("additionalParameters")) {
            return this.getAdditionalParameters().isEmpty() ? " " : Joiner.on((char)' ').join((Iterable)this.getAdditionalParameters());
        }
        return value;
    }

    private String toOnOffString(boolean flag) {
        return flag ? "on" : "off";
    }
}

