/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Action;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.UUIDGenerator;
import org.gradle.internal.serialize.Serializers;
import org.gradle.launcher.daemon.protocol.DaemonMessageSerializer;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.server.DaemonServerConnector;
import org.gradle.launcher.daemon.server.IncomingConnectionHandler;
import org.gradle.launcher.daemon.server.SynchronizedDispatchConnection;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.ConnectionAcceptor;
import org.gradle.messaging.remote.internal.ConnectCompletion;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.IncomingConnector;
import org.gradle.messaging.remote.internal.KryoBackedMessageSerializer;
import org.gradle.messaging.remote.internal.MessageSerializer;
import org.gradle.messaging.remote.internal.inet.InetAddressFactory;
import org.gradle.messaging.remote.internal.inet.TcpIncomingConnector;

public class DaemonTcpServerConnector
implements DaemonServerConnector {
    private final IncomingConnector incomingConnector;
    private boolean started;
    private boolean stopped;
    private final Lock lifecycleLock = new ReentrantLock();
    private ConnectionAcceptor acceptor;

    public DaemonTcpServerConnector(ExecutorFactory executorFactory, InetAddressFactory inetAddressFactory) {
        this.incomingConnector = new TcpIncomingConnector(executorFactory, inetAddressFactory, (IdGenerator)new UUIDGenerator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address start(final IncomingConnectionHandler handler) {
        this.lifecycleLock.lock();
        try {
            if (this.stopped) {
                throw new IllegalStateException("server connector cannot be started as it is either stopping or has been stopped");
            }
            if (this.started) {
                throw new IllegalStateException("server connector cannot be started as it has already been started");
            }
            Action<ConnectCompletion> connectEvent = new Action<ConnectCompletion>(){

                @Override
                public void execute(ConnectCompletion completion) {
                    KryoBackedMessageSerializer serializer = new KryoBackedMessageSerializer(Serializers.stateful(DaemonMessageSerializer.create()));
                    handler.handle(new SynchronizedDispatchConnection<Message>((Connection<Message>)completion.create((MessageSerializer)serializer)));
                }
            };
            this.acceptor = this.incomingConnector.accept((Action)connectEvent, false);
            this.started = true;
            Address address = this.acceptor.getAddress();
            return address;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.lifecycleLock.lock();
        try {
            this.stopped = true;
        }
        finally {
            this.lifecycleLock.unlock();
        }
        CompositeStoppable.stoppable(this.acceptor, this.incomingConnector).stop();
    }
}

