/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.progress;

import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Project;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.ProjectState;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskState;
import org.gradle.internal.progress.BuildProgressLogger;

public class BuildProgressFilter
implements BuildListener,
TaskExecutionGraphListener,
TaskExecutionListener,
ProjectEvaluationListener {
    private Gradle gradle;
    private BuildProgressLogger logger;

    public BuildProgressFilter(BuildProgressLogger logger) {
        this.logger = logger;
    }

    public void buildStarted(Gradle gradle) {
        if (gradle.getParent() == null) {
            this.gradle = gradle;
            this.logger.buildStarted();
        }
    }

    public void settingsEvaluated(Settings settings) {
        if (settings.getGradle() == this.gradle) {
            this.logger.settingsEvaluated();
        }
    }

    public void projectsLoaded(Gradle gradle) {
        if (gradle == this.gradle) {
            this.logger.projectsLoaded(gradle.getRootProject().getAllprojects().size());
        }
    }

    public void graphPopulated(TaskExecutionGraph graph) {
        if (this.gradle != null && graph == this.gradle.getTaskGraph()) {
            this.logger.graphPopulated(graph.getAllTasks().size());
        }
    }

    public void beforeEvaluate(Project project) {
        if (project.getGradle() == this.gradle) {
            this.logger.beforeEvaluate(project.getPath());
        }
    }

    public void afterEvaluate(Project project, ProjectState state) {
        if (project.getGradle() == this.gradle) {
            this.logger.afterEvaluate(project.getPath());
        }
    }

    public void projectsEvaluated(Gradle gradle) {
    }

    public void beforeExecute(Task task) {
    }

    public void afterExecute(Task task, TaskState state) {
        if (task.getProject().getGradle() == this.gradle) {
            this.logger.afterExecute();
        }
    }

    public void buildFinished(BuildResult result) {
        if (result.getGradle() == this.gradle) {
            this.gradle = null;
            this.logger.buildFinished();
        }
    }
}

