/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.child;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.logging.LogLevel;
import org.gradle.messaging.remote.Address;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.WorkerProcessBuilder;
import org.gradle.process.internal.child.ActionExecutionWorker;
import org.gradle.process.internal.child.BootstrapSecurityManager;
import org.gradle.process.internal.child.EncodedStream;
import org.gradle.process.internal.child.WorkerFactory;
import org.gradle.process.internal.launcher.GradleWorkerMain;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationClassesInSystemClassLoaderWorkerFactory
implements WorkerFactory {
    private final Object workerId;
    private final String displayName;
    private final WorkerProcessBuilder processBuilder;
    private final List<URL> implementationClassPath;
    private final Address serverAddress;
    private final ClassPathRegistry classPathRegistry;

    public ApplicationClassesInSystemClassLoaderWorkerFactory(Object workerId, String displayName, WorkerProcessBuilder processBuilder, List<URL> implementationClassPath, Address serverAddress, ClassPathRegistry classPathRegistry) {
        this.workerId = workerId;
        this.displayName = displayName;
        this.processBuilder = processBuilder;
        this.implementationClassPath = implementationClassPath;
        this.serverAddress = serverAddress;
        this.classPathRegistry = classPathRegistry;
    }

    @Override
    public void prepareJavaCommand(JavaExecSpec execSpec) {
        execSpec.setMain("jarjar." + GradleWorkerMain.class.getName());
        execSpec.classpath(this.classPathRegistry.getClassPath("WORKER_MAIN").getAsFiles());
        Object requestedSecurityManager = execSpec.getSystemProperties().get("java.security.manager");
        execSpec.systemProperty("java.security.manager", "jarjar." + BootstrapSecurityManager.class.getName());
        List workerClassPath = this.classPathRegistry.getClassPath("WORKER_PROCESS").getAsURLs();
        ActionExecutionWorker worker = this.create();
        Set<File> applicationClasspath = this.processBuilder.getApplicationClasspath();
        LogLevel logLevel = this.processBuilder.getLogLevel();
        Set<String> sharedPackages = this.processBuilder.getSharedPackages();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            DataOutputStream outstr = new DataOutputStream(new EncodedStream.EncodedOutput(bytes));
            outstr.writeInt(applicationClasspath.size());
            for (File file : applicationClasspath) {
                outstr.writeUTF(file.getAbsolutePath());
            }
            outstr.writeUTF(requestedSecurityManager == null ? "" : requestedSecurityManager.toString());
            outstr.writeInt(workerClassPath.size());
            for (URL entry : workerClassPath) {
                outstr.writeUTF(entry.toString());
            }
            outstr.writeInt(logLevel.ordinal());
            outstr.writeInt(sharedPackages.size());
            for (String str : sharedPackages) {
                outstr.writeUTF(str);
            }
            outstr.writeInt(this.implementationClassPath.size());
            for (URL entry : this.implementationClassPath) {
                outstr.writeUTF(entry.toString());
            }
            byte[] serializedWorker = GUtil.serialize((Object)worker);
            outstr.writeInt(serializedWorker.length);
            outstr.write(serializedWorker);
            outstr.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        execSpec.setStandardInput(new ByteArrayInputStream(bytes.toByteArray()));
    }

    private ActionExecutionWorker create() {
        return new ActionExecutionWorker(this.processBuilder.getWorker(), this.workerId, this.displayName, this.serverAddress, this.processBuilder.getGradleUserHomeDir());
    }
}

