/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.application.CreateStartScripts;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Tar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.internal.FileUtils;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.tasks.Jar;
import org.gradle.model.Defaults;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.play.PlayApplicationBinarySpec;
import org.gradle.play.distribution.PlayDistribution;
import org.gradle.play.distribution.PlayDistributionContainer;
import org.gradle.play.internal.PlayApplicationBinarySpecInternal;
import org.gradle.play.internal.distribution.DefaultPlayDistribution;
import org.gradle.play.internal.distribution.DefaultPlayDistributionContainer;
import org.gradle.play.plugins.PlayPluginConfigurations;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class PlayDistributionPlugin
extends RuleSource {
    public static final String DISTRIBUTION_GROUP = "distribution";
    public static final String DIST_LIFECYCLE_TASK_NAME = "dist";
    public static final String STAGE_LIFECYCLE_TASK_NAME = "stage";

    @Model
    PlayDistributionContainer distributions(ServiceRegistry serviceRegistry) {
        Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
        return new DefaultPlayDistributionContainer(instantiator);
    }

    @Mutate
    void createLifecycleTasks(ModelMap<Task> tasks) {
        tasks.create(DIST_LIFECYCLE_TASK_NAME, (Action)new Action<Task>(){

            public void execute(Task task) {
                task.setDescription("Assembles all Play distributions.");
                task.setGroup(PlayDistributionPlugin.DISTRIBUTION_GROUP);
            }
        });
        tasks.create(STAGE_LIFECYCLE_TASK_NAME, (Action)new Action<Task>(){

            public void execute(Task task) {
                task.setDescription("Stages all Play distributions.");
                task.setGroup(PlayDistributionPlugin.DISTRIBUTION_GROUP);
            }
        });
    }

    @Defaults
    void createDistributions(@Path(value="distributions") PlayDistributionContainer distributions, ModelMap<PlayApplicationBinarySpecInternal> playBinaries, PlayPluginConfigurations configurations, ServiceRegistry serviceRegistry) {
        FileOperations fileOperations = (FileOperations)serviceRegistry.get(FileOperations.class);
        Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
        for (PlayApplicationBinarySpecInternal binary : playBinaries) {
            PlayDistribution distribution = (PlayDistribution)instantiator.newInstance(DefaultPlayDistribution.class, new Object[]{binary.getProjectScopedName(), fileOperations.copySpec(), binary});
            distribution.setBaseName(binary.getProjectScopedName());
            distributions.add(distribution);
        }
    }

    @Mutate
    void createDistributionContentTasks(ModelMap<Task> tasks, @Path(value="buildDir") File buildDir, @Path(value="distributions") PlayDistributionContainer distributions, final PlayPluginConfigurations configurations) {
        for (final PlayDistribution distribution : distributions.withType(PlayDistribution.class)) {
            final PlayApplicationBinarySpec binary = distribution.getBinary();
            if (binary == null) {
                throw new InvalidUserCodeException(String.format("Play Distribution '%s' does not have a configured Play binary.", distribution.getName()));
            }
            final File distJarDir = new File(buildDir, String.format("distributionJars/%s", distribution.getName()));
            String jarTaskName = String.format("create%sDistributionJar", StringUtils.capitalize((String)distribution.getName()));
            tasks.create(jarTaskName, Jar.class, (Action)new Action<Jar>(){

                public void execute(Jar jar) {
                    jar.setDescription("Assembles an application jar suitable for deployment for the " + binary + ".");
                    jar.dependsOn(new Object[]{binary.getTasks().withType(Jar.class)});
                    jar.from(new Object[]{jar.getProject().zipTree((Object)binary.getJarFile())});
                    jar.setDestinationDir(distJarDir);
                    jar.setArchiveName(binary.getJarFile().getName());
                    HashMap classpath = Maps.newHashMap();
                    classpath.put("Class-Path", new PlayManifestClasspath(configurations.getPlayRun(), binary.getAssetsJarFile()));
                    jar.getManifest().attributes((Map)classpath);
                }
            });
            final Task distributionJar = (Task)tasks.get(jarTaskName);
            final File scriptsDir = new File(buildDir, String.format("scripts/%s", distribution.getName()));
            String createStartScriptsTaskName = String.format("create%sStartScripts", StringUtils.capitalize((String)distribution.getName()));
            tasks.create(createStartScriptsTaskName, CreateStartScripts.class, (Action)new Action<CreateStartScripts>(){

                public void execute(CreateStartScripts createStartScripts) {
                    createStartScripts.setDescription("Creates OS specific scripts to run the " + binary + ".");
                    createStartScripts.setClasspath(distributionJar.getOutputs().getFiles());
                    createStartScripts.setMainClassName("play.core.server.NettyServer");
                    createStartScripts.setApplicationName(distribution.getName());
                    createStartScripts.setOutputDir(scriptsDir);
                }
            });
            Task createStartScripts = (Task)tasks.get(createStartScriptsTaskName);
            CopySpecInternal distSpec = (CopySpecInternal)distribution.getContents();
            CopySpec libSpec = distSpec.addChild().into((Object)"lib");
            libSpec.from(new Object[]{distributionJar});
            libSpec.from(new Object[]{binary.getAssetsJarFile()});
            libSpec.from(new Object[]{configurations.getPlayRun().getAllArtifacts()});
            libSpec.eachFile((Action)new PrefixArtifactFileNames(configurations.getPlayRun()));
            CopySpec binSpec = distSpec.addChild().into((Object)"bin");
            binSpec.from(new Object[]{createStartScripts});
            binSpec.setFileMode(Integer.valueOf(493));
            CopySpec confSpec = distSpec.addChild().into((Object)"conf");
            confSpec.from(new Object[]{"conf"}).exclude(new String[]{"routes"});
            distSpec.from(new Object[]{"README"});
        }
    }

    @Mutate
    void createDistributionZipTasks(ModelMap<Task> tasks, final @Path(value="buildDir") File buildDir, PlayDistributionContainer distributions) {
        for (final PlayDistribution distribution : distributions.withType(PlayDistribution.class)) {
            final String stageTaskName = String.format("stage%sDist", StringUtils.capitalize((String)distribution.getName()));
            final File stageDir = new File(buildDir, STAGE_LIFECYCLE_TASK_NAME);
            final String baseName = StringUtils.isNotEmpty((String)distribution.getBaseName()) ? distribution.getBaseName() : distribution.getName();
            tasks.create(stageTaskName, Sync.class, (Action)new Action<Sync>(){

                public void execute(Sync sync) {
                    sync.setDescription("Copies the '" + distribution.getName() + "' distribution to a staging directory.");
                    sync.setDestinationDir(stageDir);
                    CopySpecInternal baseSpec = sync.getRootSpec().addChild();
                    baseSpec.into((Object)baseName);
                    baseSpec.with(new CopySpec[]{distribution.getContents()});
                }
            });
            tasks.named(STAGE_LIFECYCLE_TASK_NAME, (Action)new Action<Task>(){

                public void execute(Task task) {
                    task.dependsOn(new Object[]{stageTaskName});
                }
            });
            final Task stageTask = (Task)tasks.get(stageTaskName);
            final String distributionZipTaskName = String.format("create%sZipDist", StringUtils.capitalize((String)distribution.getName()));
            tasks.create(distributionZipTaskName, Zip.class, (Action)new Action<Zip>(){

                public void execute(Zip zip) {
                    zip.setDescription("Packages the '" + distribution.getName() + "' distribution as a zip file.");
                    zip.setBaseName(baseName);
                    zip.setDestinationDir(new File(buildDir, "distributions"));
                    zip.from(new Object[]{stageTask});
                }
            });
            final String distributionTarTaskName = String.format("create%sTarDist", StringUtils.capitalize((String)distribution.getName()));
            tasks.create(distributionTarTaskName, Tar.class, (Action)new Action<Tar>(){

                public void execute(Tar tar) {
                    tar.setDescription("Packages the '" + distribution.getName() + "' distribution as a tar file.");
                    tar.setBaseName(baseName);
                    tar.setDestinationDir(new File(buildDir, "distributions"));
                    tar.from(new Object[]{stageTask});
                }
            });
            tasks.named(distributionTarTaskName, DistributionArchiveRules.class);
            tasks.named(distributionZipTaskName, DistributionArchiveRules.class);
            tasks.named(DIST_LIFECYCLE_TASK_NAME, (Action)new Action<Task>(){

                public void execute(Task task) {
                    task.dependsOn(new Object[]{distributionZipTaskName, distributionTarTaskName});
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PrefixArtifactFileNames
    implements Action<FileCopyDetails>,
    Function<File, String> {
        private final PlayPluginConfigurations.PlayConfiguration configuration;
        ImmutableMap<File, String> renames;

        PrefixArtifactFileNames(PlayPluginConfigurations.PlayConfiguration configuration) {
            this.configuration = configuration;
        }

        public void execute(FileCopyDetails fileCopyDetails) {
            fileCopyDetails.setName(this.apply(fileCopyDetails.getFile()));
        }

        public String apply(File input) {
            this.calculateRenames();
            String rename = (String)this.renames.get((Object)input);
            if (rename != null) {
                return rename;
            }
            return input.getName();
        }

        private void calculateRenames() {
            if (this.renames == null) {
                this.renames = this.calculate();
            }
        }

        private ImmutableMap<File, String> calculate() {
            ImmutableMap.Builder files = ImmutableMap.builder();
            for (ResolvedArtifact artifact : this.getResolvedArtifacts()) {
                boolean isProject = artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier;
                if (isProject) {
                    ProjectComponentIdentifier projectComponentIdentifier = (ProjectComponentIdentifier)artifact.getId().getComponentIdentifier();
                    files.put((Object)artifact.getFile(), (Object)PrefixArtifactFileNames.renameForProject(projectComponentIdentifier, artifact.getFile()));
                    continue;
                }
                boolean isExternalModule = artifact.getId().getComponentIdentifier() instanceof ModuleComponentIdentifier;
                if (isExternalModule) {
                    ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)artifact.getId().getComponentIdentifier();
                    files.put((Object)artifact.getFile(), (Object)PrefixArtifactFileNames.renameForModule(moduleComponentIdentifier, artifact.getFile()));
                    continue;
                }
                files.put((Object)artifact.getFile(), (Object)artifact.getFile().getName());
            }
            return files.build();
        }

        Set<ResolvedArtifact> getResolvedArtifacts() {
            return this.configuration.getConfiguration().getResolvedConfiguration().getResolvedArtifacts();
        }

        static String renameForProject(ProjectComponentIdentifier id, File file) {
            String fileName = file.getName();
            if (PrefixArtifactFileNames.shouldBeRenamed(file)) {
                String projectPath = id.getProjectPath();
                projectPath = PrefixArtifactFileNames.projectPathToSafeFileName(projectPath);
                return PrefixArtifactFileNames.maybePrefix(projectPath, file);
            }
            return fileName;
        }

        static String renameForModule(ModuleComponentIdentifier id, File file) {
            if (PrefixArtifactFileNames.shouldBeRenamed(file)) {
                return PrefixArtifactFileNames.maybePrefix(id.getGroup(), file);
            }
            return file.getName();
        }

        private static String maybePrefix(String prefix, File file) {
            if (!GUtil.isTrue((Object)prefix)) {
                return file.getName();
            }
            return String.format("%s-%s", prefix, file.getName());
        }

        private static String projectPathToSafeFileName(String projectPath) {
            if (projectPath.equals(":")) {
                return null;
            }
            return projectPath.replaceAll(":", ".").substring(1);
        }

        private static boolean shouldBeRenamed(File file) {
            return FileUtils.hasExtension((File)file, (String)".jar");
        }
    }

    static class PlayManifestClasspath {
        final PlayPluginConfigurations.PlayConfiguration playConfiguration;
        final File assetsJarFile;

        public PlayManifestClasspath(PlayPluginConfigurations.PlayConfiguration playConfiguration, File assetsJarFile) {
            this.playConfiguration = playConfiguration;
            this.assetsJarFile = assetsJarFile;
        }

        public String toString() {
            return Joiner.on((String)" ").join(Iterables.transform((Iterable)Iterables.concat((Iterable)this.playConfiguration.getAllArtifacts(), Collections.singleton(this.assetsJarFile)), (Function)new PrefixArtifactFileNames(this.playConfiguration)));
        }
    }

    static class DistributionArchiveRules
    extends RuleSource {
        DistributionArchiveRules() {
        }

        @Finalize
        void fixupDistributionArchiveNames(AbstractArchiveTask archiveTask) {
            archiveTask.setArchiveName(String.format("%s.%s", archiveTask.getBaseName(), archiveTask.getExtension()));
        }
    }
}

