/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.resolve;

import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultResolutionStrategy;
import org.gradle.internal.component.local.model.UsageKind;
import org.gradle.internal.component.model.ComponentResolveMetaData;
import org.gradle.language.base.internal.model.DefaultLibraryLocalComponentMetaData;
import org.gradle.language.base.internal.model.VariantsMetaData;
import org.gradle.platform.base.DependencySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalComponentResolveContext
implements ResolveContext {
    private final LibraryBinaryIdentifier libraryBinaryIdentifier;
    private final String displayName;
    private final UsageKind usage;
    private final ResolutionStrategyInternal resolutionStrategy = new DefaultResolutionStrategy();
    private final VariantsMetaData variants;
    private final Iterable<DependencySpec> dependencies;

    public LocalComponentResolveContext(LibraryBinaryIdentifier libraryBinaryIdentifier, VariantsMetaData variants, Iterable<DependencySpec> dependencies, UsageKind usage, String displayName) {
        this.libraryBinaryIdentifier = libraryBinaryIdentifier;
        this.usage = usage;
        this.displayName = displayName;
        this.variants = variants;
        this.dependencies = dependencies;
    }

    public String getName() {
        return this.usage.getConfigurationName();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public VariantsMetaData getVariants() {
        return this.variants;
    }

    public ResolutionStrategyInternal getResolutionStrategy() {
        return this.resolutionStrategy;
    }

    public ComponentResolveMetaData toRootComponentMetaData() {
        return DefaultLibraryLocalComponentMetaData.newResolvingLocalComponentMetadata(this.libraryBinaryIdentifier, this.usage, this.dependencies);
    }
}

