/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.plugins;

import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Iterator;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.model.Validate;
import org.gradle.model.internal.core.DirectNodeNoInputsModelAction;
import org.gradle.model.internal.core.Hidden;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelNodes;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.NodePredicate;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.manage.binding.StructBindingsStore;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.extract.FactoryBasedStructNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.NodeInitializerExtractionStrategy;
import org.gradle.model.internal.registry.ModelReferenceNode;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryType;
import org.gradle.platform.base.BinaryTypeBuilder;
import org.gradle.platform.base.binary.BaseBinarySpec;
import org.gradle.platform.base.binary.internal.BaseBinaryRules;
import org.gradle.platform.base.binary.internal.BinarySpecFactory;
import org.gradle.platform.base.internal.BinarySpecInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class BinaryBasePlugin
implements Plugin<Project> {
    private final ModelRegistry modelRegistry;

    @Inject
    public BinaryBasePlugin(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
    }

    public void apply(Project target) {
        target.getPluginManager().apply(LifecycleBasePlugin.class);
        this.applyRules(this.modelRegistry);
    }

    private void applyRules(ModelRegistry modelRegistry) {
        SimpleModelRuleDescriptor ruleDescriptor = new SimpleModelRuleDescriptor(BinaryBasePlugin.class.getSimpleName() + ".apply()");
        modelRegistry.getRoot().applyTo(NodePredicate.allDescendants((Predicate)ModelNodes.withType(BinarySpec.class)), ModelActionRole.Defaults, DirectNodeNoInputsModelAction.of((ModelReference)ModelReference.of(BinarySpec.class), (ModelRuleDescriptor)ruleDescriptor, (Action)new Action<MutableModelNode>(){

            public void execute(MutableModelNode binaryNode) {
                if (binaryNode instanceof ModelReferenceNode) {
                    return;
                }
                binaryNode.applyToSelf(BaseBinaryRules.class);
            }
        }));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Model
        void binaries(BinaryContainer binaries) {
        }

        @Hidden
        @Model
        BinarySpecFactory binarySpecFactory(ServiceRegistry serviceRegistry, ITaskFactory taskFactory) {
            return new BinarySpecFactory("binaries", (Instantiator)serviceRegistry.get(Instantiator.class), taskFactory);
        }

        @Mutate
        void registerNodeInitializerExtractors(NodeInitializerRegistry nodeInitializerRegistry, BinarySpecFactory binarySpecFactory, ModelSchemaStore schemaStore, StructBindingsStore bindingsStore) {
            nodeInitializerRegistry.registerStrategy((NodeInitializerExtractionStrategy)new FactoryBasedStructNodeInitializerExtractionStrategy((InstanceFactory)binarySpecFactory, schemaStore, bindingsStore));
        }

        @Validate
        void validateBinarySpecRegistrations(BinarySpecFactory instanceFactory) {
            instanceFactory.validateRegistrations();
        }

        @BinaryType
        void registerBaseBinarySpec(BinaryTypeBuilder<BinarySpec> builder) {
            builder.defaultImplementation(BaseBinarySpec.class);
            builder.internalView(BinarySpecInternal.class);
        }

        @Mutate
        void copyBinaryTasksToTaskContainer(TaskContainer tasks, BinaryContainer binaries) {
            Iterator i$ = binaries.iterator();
            while (i$.hasNext()) {
                BinarySpec binary = (BinarySpec)i$.next();
                tasks.addAll((Collection)((Object)binary.getTasks()));
                Task buildTask = binary.getBuildTask();
                if (buildTask == null) continue;
                tasks.add((Object)buildTask);
            }
        }
    }
}

