/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import java.io.File;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.internal.resolve.ArtifactNotFoundException;
import org.gradle.internal.resolve.ArtifactResolveException;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;

public class DefaultBuildableArtifactResolveResult
extends DefaultResourceAwareResolveResult
implements BuildableArtifactResolveResult {
    private ArtifactResolveException failure;
    private File file;

    public void failed(ArtifactResolveException failure) {
        this.failure = failure;
    }

    public void resolved(File file) {
        this.file = file;
    }

    public void notFound(ComponentArtifactIdentifier artifact) {
        this.failed(new ArtifactNotFoundException(artifact, this.getAttempted()));
    }

    public ArtifactResolveException getFailure() {
        this.assertHasResult();
        return this.failure;
    }

    public File getFile() throws ArtifactResolveException {
        this.assertResolved();
        return this.file;
    }

    public boolean hasResult() {
        return this.failure != null || this.file != null;
    }

    private void assertResolved() {
        this.assertHasResult();
        if (this.failure != null) {
            throw this.failure;
        }
    }

    private void assertHasResult() {
        if (!this.hasResult()) {
            throw new IllegalStateException("No result has been specified.");
        }
    }
}

