/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.logging;

import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.logging.DefaultTestLogging;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.testing.logging.TestExceptionFormat;
import org.gradle.api.tasks.testing.logging.TestLogEvent;
import org.gradle.api.tasks.testing.logging.TestLogging;
import org.gradle.api.tasks.testing.logging.TestLoggingContainer;
import org.gradle.api.tasks.testing.logging.TestStackTraceFilter;
import org.gradle.internal.reflect.Instantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTestLoggingContainer
implements TestLoggingContainer {
    private final Map<LogLevel, TestLogging> perLevelTestLogging = Maps.newEnumMap(LogLevel.class);

    public DefaultTestLoggingContainer(Instantiator instantiator) {
        for (LogLevel level : LogLevel.values()) {
            this.perLevelTestLogging.put(level, (TestLogging)instantiator.newInstance(DefaultTestLogging.class, new Object[0]));
        }
        this.setEvents(EnumSet.of(TestLogEvent.FAILED));
        this.setExceptionFormat((Object)TestExceptionFormat.SHORT);
        this.getInfo().setEvents(EnumSet.of(TestLogEvent.FAILED, TestLogEvent.SKIPPED, TestLogEvent.STANDARD_OUT, TestLogEvent.STANDARD_ERROR));
        this.getInfo().setStackTraceFilters(EnumSet.of(TestStackTraceFilter.TRUNCATE));
        this.getDebug().setEvents(EnumSet.allOf(TestLogEvent.class));
        this.getDebug().setMinGranularity(0);
        this.getDebug().setStackTraceFilters(EnumSet.noneOf(TestStackTraceFilter.class));
    }

    @Override
    public TestLogging getDebug() {
        return this.perLevelTestLogging.get(LogLevel.DEBUG);
    }

    @Override
    public void setDebug(TestLogging logging) {
        this.perLevelTestLogging.put(LogLevel.DEBUG, logging);
    }

    @Override
    public void debug(Action<TestLogging> action) {
        action.execute((Object)this.getDebug());
    }

    @Override
    public TestLogging getInfo() {
        return this.perLevelTestLogging.get(LogLevel.INFO);
    }

    @Override
    public void setInfo(TestLogging logging) {
        this.perLevelTestLogging.put(LogLevel.INFO, logging);
    }

    @Override
    public void info(Action<TestLogging> action) {
        action.execute((Object)this.getInfo());
    }

    @Override
    public TestLogging getLifecycle() {
        return this.perLevelTestLogging.get(LogLevel.LIFECYCLE);
    }

    @Override
    public void setLifecycle(TestLogging logging) {
        this.perLevelTestLogging.put(LogLevel.LIFECYCLE, logging);
    }

    @Override
    public void lifecycle(Action<TestLogging> action) {
        action.execute((Object)this.getLifecycle());
    }

    @Override
    public TestLogging getWarn() {
        return this.perLevelTestLogging.get(LogLevel.WARN);
    }

    @Override
    public void setWarn(TestLogging logging) {
        this.perLevelTestLogging.put(LogLevel.WARN, logging);
    }

    @Override
    public void warn(Action<TestLogging> action) {
        action.execute((Object)this.getWarn());
    }

    @Override
    public TestLogging getQuiet() {
        return this.perLevelTestLogging.get(LogLevel.QUIET);
    }

    @Override
    public void setQuiet(TestLogging logging) {
        this.perLevelTestLogging.put(LogLevel.QUIET, logging);
    }

    @Override
    public void quiet(Action<TestLogging> action) {
        action.execute((Object)this.getQuiet());
    }

    @Override
    public TestLogging getError() {
        return this.perLevelTestLogging.get(LogLevel.ERROR);
    }

    @Override
    public void setError(TestLogging logging) {
        this.perLevelTestLogging.put(LogLevel.ERROR, logging);
    }

    @Override
    public void error(Action<TestLogging> action) {
        action.execute((Object)this.getError());
    }

    @Override
    public Set<TestLogEvent> getEvents() {
        return this.getLifecycle().getEvents();
    }

    @Override
    public void setEvents(Iterable<?> events) {
        this.getLifecycle().setEvents(events);
    }

    @Override
    public void events(Object ... events) {
        this.getLifecycle().events(events);
    }

    @Override
    public int getMinGranularity() {
        return this.getLifecycle().getMinGranularity();
    }

    @Override
    public void setMinGranularity(int granularity) {
        this.getLifecycle().setMinGranularity(granularity);
    }

    @Override
    public int getMaxGranularity() {
        return this.getLifecycle().getMaxGranularity();
    }

    @Override
    public void setMaxGranularity(int granularity) {
        this.getLifecycle().setMaxGranularity(granularity);
    }

    @Override
    public int getDisplayGranularity() {
        return this.getLifecycle().getDisplayGranularity();
    }

    @Override
    public void setDisplayGranularity(int granularity) {
        this.getLifecycle().setDisplayGranularity(granularity);
    }

    @Override
    public boolean getShowExceptions() {
        return this.getLifecycle().getShowExceptions();
    }

    @Override
    public void setShowExceptions(boolean flag) {
        this.getLifecycle().setShowExceptions(flag);
    }

    @Override
    public boolean getShowCauses() {
        return this.getLifecycle().getShowCauses();
    }

    @Override
    public void setShowCauses(boolean flag) {
        this.getLifecycle().setShowCauses(flag);
    }

    @Override
    public boolean getShowStackTraces() {
        return this.getLifecycle().getShowStackTraces();
    }

    @Override
    public void setShowStackTraces(boolean flag) {
        this.getLifecycle().setShowStackTraces(flag);
    }

    @Override
    public TestExceptionFormat getExceptionFormat() {
        return this.getLifecycle().getExceptionFormat();
    }

    @Override
    public void setExceptionFormat(Object exceptionFormat) {
        this.getLifecycle().setExceptionFormat(exceptionFormat);
    }

    @Override
    public Set<TestStackTraceFilter> getStackTraceFilters() {
        return this.getLifecycle().getStackTraceFilters();
    }

    @Override
    public void setStackTraceFilters(Iterable<?> stackTraces) {
        this.getLifecycle().setStackTraceFilters(stackTraces);
    }

    @Override
    public void stackTraceFilters(Object ... stackTraces) {
        this.getLifecycle().stackTraceFilters(stackTraces);
    }

    @Override
    public boolean getShowStandardStreams() {
        return this.getLifecycle().getShowStandardStreams();
    }

    @Override
    public TestLoggingContainer setShowStandardStreams(boolean flag) {
        this.getLifecycle().setShowStandardStreams(flag);
        return this;
    }

    @Override
    public TestLogging get(LogLevel level) {
        return this.perLevelTestLogging.get(level);
    }
}

