/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.projection;

import com.google.common.base.Optional;
import groovy.lang.Closure;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.typeconversion.TypeConverter;
import org.gradle.model.ModelViewClosedException;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.TypeCompatibilityModelProjectionSupport;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.manage.binding.StructBindings;
import org.gradle.model.internal.manage.instance.ManagedInstance;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.instance.ModelElementState;
import org.gradle.model.internal.manage.schema.ManagedImplSchema;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ScalarCollectionSchema;
import org.gradle.model.internal.manage.schema.StructSchema;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedModelProjection<M>
extends TypeCompatibilityModelProjectionSupport<M> {
    private static final ModelType<? extends Collection<?>> COLLECTION_MODEL_TYPE = new ModelType<Collection<?>>(){};
    private final StructSchema<M> schema;
    private final StructBindings<?> bindings;
    private final ManagedProxyFactory proxyFactory;
    private final TypeConverter typeConverter;

    public ManagedModelProjection(StructSchema<M> schema, StructBindings<?> bindings, ManagedProxyFactory proxyFactory, TypeConverter typeConverter) {
        super(schema.getType());
        this.schema = schema;
        this.bindings = bindings;
        this.proxyFactory = proxyFactory;
        this.typeConverter = typeConverter;
    }

    @Override
    protected ModelView<M> toView(final MutableModelNode modelNode, final ModelRuleDescriptor ruleDescriptor, final boolean writable) {
        return new ModelView<M>(){
            private boolean closed;
            private final Map<String, Object> propertyViews = new HashMap<String, Object>();

            @Override
            public ModelPath getPath() {
                return modelNode.getPath();
            }

            @Override
            public ModelType<M> getType() {
                return ManagedModelProjection.this.getType();
            }

            @Override
            public M getInstance() {
                return ManagedModelProjection.this.proxyFactory.createProxy(new State(), ManagedModelProjection.this.schema, ManagedModelProjection.this.bindings, ManagedModelProjection.this.typeConverter);
            }

            @Override
            public void close() {
                this.closed = true;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class State
            implements ModelElementState {
                State() {
                }

                @Override
                public MutableModelNode getBackingNode() {
                    return modelNode;
                }

                @Override
                public String getDisplayName() {
                    return String.format("%s '%s'", this.getType(), modelNode.getPath().toString());
                }

                public boolean equals(Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (obj == null || obj.getClass() != this.getClass()) {
                        return false;
                    }
                    State other = (State)Cast.uncheckedCast((Object)obj);
                    return modelNode == other.getBackingNode();
                }

                public int hashCode() {
                    return modelNode.hashCode();
                }

                @Override
                public Object get(String name) {
                    if (propertyViews.containsKey(name)) {
                        return propertyViews.get(name);
                    }
                    ModelProperty<?> property = ManagedModelProjection.this.schema.getProperty(name);
                    Object value = this.doGet(property, name);
                    propertyViews.put(name, value);
                    return value;
                }

                private <T> T doGet(ModelProperty<T> property, String propertyName) {
                    ModelView<T> modelView;
                    Collection instance;
                    ModelType<T> propertyType = property.getType();
                    MutableModelNode propertyNode = modelNode.getLink(propertyName);
                    propertyNode.ensureUsable();
                    ModelSchema<T> propertySchema = property.getSchema();
                    if (property.isWritable() && propertySchema instanceof ScalarCollectionSchema && (instance = ScalarCollectionSchema.get(propertyNode)) == null) {
                        return null;
                    }
                    if (writable) {
                        modelView = propertyNode.asMutable(propertyType, ruleDescriptor);
                        if (closed) {
                            modelView.close();
                        }
                    } else {
                        modelView = propertyNode.asImmutable(propertyType, ruleDescriptor);
                    }
                    return modelView.getInstance();
                }

                @Override
                public void apply(String name, Closure<?> action) {
                    ClosureBackedAction.execute((Object)this.get(name), action);
                }

                @Override
                public void set(String name, Object value) {
                    if (!writable || closed) {
                        throw new ModelViewClosedException(this.getType(), ruleDescriptor);
                    }
                    ModelProperty<?> property = ManagedModelProjection.this.schema.getProperty(name);
                    value = this.doSet(name, value, property);
                    propertyViews.put(name, value);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                private <T> Object doSet(String name, Object value, ModelProperty<T> property) {
                    ModelSchema<T> propertySchema = property.getSchema();
                    MutableModelNode propertyNode = modelNode.getLink(name);
                    propertyNode.ensureUsable();
                    if (!(propertySchema instanceof ManagedImplSchema)) {
                        Object castValue = Cast.uncheckedCast((Object)value);
                        propertyNode.setPrivateData(property.getType(), castValue);
                        return value;
                    }
                    if (value == null) {
                        if (propertySchema instanceof ScalarCollectionSchema) {
                            ScalarCollectionSchema.clear(propertyNode);
                            return value;
                        }
                        propertyNode.setTarget(null);
                        return value;
                    }
                    if (ManagedInstance.class.isInstance(value)) {
                        ManagedInstance managedInstance = (ManagedInstance)value;
                        MutableModelNode targetNode = managedInstance.getBackingNode();
                        propertyNode.setTarget(targetNode);
                        return value;
                    }
                    if (propertySchema instanceof ScalarCollectionSchema && value instanceof Collection) {
                        ModelView modelView = propertyNode.asMutable(COLLECTION_MODEL_TYPE, ruleDescriptor);
                        Collection instance = (Collection)Cast.uncheckedCast(modelView.getInstance());
                        Collection values = (Collection)Cast.uncheckedCast((Object)value);
                        instance.clear();
                        instance.addAll(values);
                        return instance;
                    }
                    throw new IllegalArgumentException(String.format("Only managed model instances can be set as property '%s' of class '%s'", name, this.getType()));
                }
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && super.equals(o);
    }

    @Override
    public Optional<String> getValueDescription(MutableModelNode modelNode) {
        Object instance = modelNode.asImmutable(ModelType.untyped(), null).getInstance();
        if (instance == null || JavaReflectionUtil.hasDefaultToString((Object)instance)) {
            return Optional.absent();
        }
        return Optional.of((Object)this.toStringValueDescription(instance));
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

