/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gradle.internal.Cast;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerContext;
import org.gradle.model.internal.inspect.FactoryBasedStructNodeInitializer;
import org.gradle.model.internal.manage.binding.StructBindings;
import org.gradle.model.internal.manage.binding.StructBindingsStore;
import org.gradle.model.internal.manage.schema.ManagedImplSchema;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.StructSchema;
import org.gradle.model.internal.manage.schema.extract.NodeInitializerExtractionStrategy;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryBasedStructNodeInitializerExtractionStrategy<T>
implements NodeInitializerExtractionStrategy {
    protected final InstanceFactory<T> instanceFactory;
    private final ModelSchemaStore schemaStore;
    private final StructBindingsStore bindingsStore;

    public FactoryBasedStructNodeInitializerExtractionStrategy(InstanceFactory<T> instanceFactory, ModelSchemaStore schemaStore, StructBindingsStore bindingsStore) {
        this.instanceFactory = instanceFactory;
        this.schemaStore = schemaStore;
        this.bindingsStore = bindingsStore;
    }

    public <S> NodeInitializer extractNodeInitializer(ModelSchema<S> schema, NodeInitializerContext<S> context) {
        if (!this.instanceFactory.getBaseInterface().isAssignableFrom(schema.getType())) {
            return null;
        }
        return this.getNodeInitializer((ModelSchema)Cast.uncheckedCast(schema));
    }

    private <S extends T> NodeInitializer getNodeInitializer(ModelSchema<S> schema) {
        StructSchema publicSchema = (StructSchema)Cast.uncheckedCast(schema);
        ModelType<S> publicType = schema.getType();
        InstanceFactory.ImplementationInfo<T> implementationInfo = publicSchema instanceof ManagedImplSchema ? this.instanceFactory.getManagedSubtypeImplementationInfo(publicType) : this.instanceFactory.getImplementationInfo(publicType);
        Set<ModelType<?>> internalViews = this.instanceFactory.getInternalViews(publicType);
        ModelType<T> delegateType = implementationInfo.getDelegateType();
        StructBindings bindings = this.bindingsStore.getBindings(publicSchema.getType(), internalViews, delegateType);
        return new FactoryBasedStructNodeInitializer(bindings, implementationInfo);
    }

    @Override
    public Iterable<ModelType<?>> supportedTypes() {
        return ImmutableSet.copyOf(this.instanceFactory.getSupportedTypes());
    }
}

