/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import org.gradle.api.Action;
import org.gradle.internal.BiAction;
import org.gradle.model.internal.core.ChildNodeInitializerStrategy;
import org.gradle.model.internal.core.ChildNodeInitializerStrategyAccessor;
import org.gradle.model.internal.core.ChildNodeInitializerStrategyAccessors;
import org.gradle.model.internal.core.DirectNodeInputUsingModelAction;
import org.gradle.model.internal.core.DirectNodeNoInputsModelAction;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelMapModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeBackedModelMap;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.SpecializedModelMapProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.manage.schema.SpecializedMapSchema;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecializedMapNodeInitializer<T, E>
implements NodeInitializer {
    private final SpecializedMapSchema<T, E> schema;

    public SpecializedMapNodeInitializer(SpecializedMapSchema<T, E> schema) {
        this.schema = schema;
    }

    @Override
    public Multimap<ModelActionRole, ModelAction> getActions(ModelReference<?> subject, ModelRuleDescriptor descriptor) {
        return SpecializedMapNodeInitializer.getActions(subject, descriptor, this.schema);
    }

    public static <T, E> Multimap<ModelActionRole, ModelAction> getActions(ModelReference<?> subject, ModelRuleDescriptor descriptor, final SpecializedMapSchema<T, E> schema) {
        return ImmutableSetMultimap.builder().put((Object)ModelActionRole.Discover, (Object)DirectNodeNoInputsModelAction.of(subject, descriptor, (Action<? super MutableModelNode>)new Action<MutableModelNode>(){

            public void execute(MutableModelNode modelNode) {
                ChildNodeInitializerStrategyAccessor strategyAccessor = ChildNodeInitializerStrategyAccessors.fromPrivateData();
                Class implementationType = schema.getImplementationType().asSubclass(schema.getType().getConcreteClass());
                modelNode.addProjection(new SpecializedModelMapProjection(schema.getType(), schema.getElementType(), implementationType, strategyAccessor));
                modelNode.addProjection(ModelMapModelProjection.unmanaged(schema.getElementType(), strategyAccessor));
            }
        })).put((Object)ModelActionRole.Create, (Object)DirectNodeInputUsingModelAction.of(subject, descriptor, ModelReference.of(NodeInitializerRegistry.class), new BiAction<MutableModelNode, NodeInitializerRegistry>(){

            public void execute(MutableModelNode modelNode, NodeInitializerRegistry nodeInitializerRegistry) {
                ChildNodeInitializerStrategy childFactory = NodeBackedModelMap.createUsingRegistry(schema.getElementType(), nodeInitializerRegistry);
                modelNode.setPrivateData(ModelType.of(ChildNodeInitializerStrategy.class), childFactory);
            }
        })).build();
    }
}

