/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.gradle.internal.hash.HashUtil;

public class CompilerOutputFileNamingScheme {
    private String objectFileNameSuffix;
    private File outputBaseFolder;

    public CompilerOutputFileNamingScheme withOutputBaseFolder(File outputBaseFolder) {
        this.outputBaseFolder = outputBaseFolder;
        return this;
    }

    public CompilerOutputFileNamingScheme withObjectFileNameSuffix(String suffix) {
        this.objectFileNameSuffix = suffix;
        return this;
    }

    public File map(File sourceFile) {
        String baseName = FilenameUtils.removeExtension((String)sourceFile.getName());
        String compactMD5 = HashUtil.createCompactMD5((String)sourceFile.getAbsolutePath());
        File hashDirectory = new File(this.outputBaseFolder, compactMD5);
        return new File(hashDirectory, String.format("%s%s", baseName, this.objectFileNameSuffix));
    }
}

