/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.FileUtils;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationProcessor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.BuildOperationWorker;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.SourceIncludes;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingScheme;
import org.gradle.nativeplatform.toolchain.internal.ArgsTransformer;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationWorker;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NativeCompiler<T extends NativeCompileSpec>
implements Compiler<T> {
    private final CommandLineToolInvocationWorker commandLineToolInvocationWorker;
    private final ArgsTransformer<T> argsTransformer;
    private final Transformer<T, T> specTransformer;
    private final CommandLineToolContext invocationContext;
    private final String objectFileExtension;
    private final boolean useCommandFile;
    private final Logger logger = Logging.getLogger(NativeCompiler.class);
    private final BuildOperationProcessor buildOperationProcessor;

    public NativeCompiler(BuildOperationProcessor buildOperationProcessor, CommandLineToolInvocationWorker commandLineToolInvocationWorker, CommandLineToolContext invocationContext, ArgsTransformer<T> argsTransformer, Transformer<T, T> specTransformer, String objectFileExtension, boolean useCommandFile) {
        this.invocationContext = invocationContext;
        this.objectFileExtension = objectFileExtension;
        this.useCommandFile = useCommandFile;
        this.argsTransformer = argsTransformer;
        this.specTransformer = specTransformer;
        this.commandLineToolInvocationWorker = commandLineToolInvocationWorker;
        this.buildOperationProcessor = buildOperationProcessor;
    }

    public WorkResult execute(T spec) {
        NativeCompileSpec transformedSpec = (NativeCompileSpec)this.specTransformer.transform(spec);
        List<String> genericArgs = this.getArguments(transformedSpec);
        BuildOperationQueue buildQueue = this.buildOperationProcessor.newQueue((BuildOperationWorker)this.commandLineToolInvocationWorker, spec.getOperationLogger().getLogLocation());
        File objectDir = transformedSpec.getObjectFileDir();
        for (File sourceFile : transformedSpec.getSourceFiles()) {
            CommandLineToolInvocation perFileInvocation = this.createPerFileInvocation(genericArgs, sourceFile, objectDir, spec);
            buildQueue.add((BuildOperation)perFileInvocation);
        }
        buildQueue.waitForCompletion();
        return new SimpleWorkResult(!transformedSpec.getSourceFiles().isEmpty());
    }

    protected List<String> getArguments(T spec) {
        List args = (List)this.argsTransformer.transform(spec);
        Action<List<String>> userArgTransformer = this.invocationContext.getArgAction();
        userArgTransformer.execute((Object)args);
        if (this.useCommandFile) {
            this.addOptionsFileArgs(args, spec.getTempDir());
        }
        return args;
    }

    protected List<String> getSourceArgs(File sourceFile) {
        return Collections.singletonList(sourceFile.getAbsolutePath());
    }

    protected abstract List<String> getOutputArgs(File var1);

    protected abstract void addOptionsFileArgs(List<String> var1, File var2);

    protected abstract List<String> getPCHArgs(T var1);

    protected File getOutputFileDir(File sourceFile, File objectFileDir, String fileSuffix) {
        boolean windowsPathLimitation = OperatingSystem.current().isWindows();
        File outputFile = new CompilerOutputFileNamingScheme().withObjectFileNameSuffix(fileSuffix).withOutputBaseFolder(objectFileDir).map(sourceFile);
        File outputDirectory = outputFile.getParentFile();
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        return windowsPathLimitation ? FileUtils.assertInWindowsPathLengthLimitation((File)outputFile) : outputFile;
    }

    protected List<String> maybeGetPCHArgs(T spec, File sourceFile) {
        boolean usePCH;
        if (spec.getPreCompiledHeader() == null) {
            return Lists.newArrayList();
        }
        SourceIncludes includes = spec.getSourceFileIncludes().get(sourceFile);
        final String header = spec.getPreCompiledHeader();
        List<Include> headers = includes.getIncludesAndImports();
        boolean bl = usePCH = !headers.isEmpty() && header.equals(headers.get(0).getValue());
        if (usePCH) {
            return this.getPCHArgs(spec);
        }
        boolean containsHeader = CollectionUtils.any(headers, (Spec)new Spec<Include>(){

            public boolean isSatisfiedBy(Include include) {
                return include.getValue().equals(header);
            }
        });
        if (containsHeader) {
            this.logger.log(LogLevel.WARN, NativeCompiler.getCantUsePCHMessage(spec.getPreCompiledHeader(), sourceFile));
        }
        return Lists.newArrayList();
    }

    private static String getCantUsePCHMessage(String pchHeader, File sourceFile) {
        return "The source file ".concat(sourceFile.getName()).concat(" includes the header ").concat(pchHeader).concat(" but it is not the first declared header, so the pre-compiled header will not be used.");
    }

    protected CommandLineToolInvocation createPerFileInvocation(List<String> genericArgs, File sourceFile, File objectDir, T spec) {
        String objectFileSuffix = this.objectFileExtension;
        List<String> sourceArgs = this.getSourceArgs(sourceFile);
        List<String> outputArgs = this.getOutputArgs(this.getOutputFileDir(sourceFile, objectDir, objectFileSuffix));
        List<String> pchArgs = this.maybeGetPCHArgs(spec, sourceFile);
        return this.invocationContext.createInvocation("compiling ".concat(sourceFile.getName()), objectDir, this.buildPerFileArgs(genericArgs, sourceArgs, outputArgs, pchArgs), spec.getOperationLogger());
    }

    protected Iterable<String> buildPerFileArgs(List<String> genericArgs, List<String> sourceArgs, List<String> outputArgs, List<String> pchArgs) {
        return Iterables.concat(genericArgs, pchArgs, sourceArgs, outputArgs);
    }
}

