/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.gcc.version;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.nativeplatform.toolchain.internal.gcc.version.CompilerMetaDataProvider;
import org.gradle.nativeplatform.toolchain.internal.gcc.version.GccVersionDeterminer;
import org.gradle.nativeplatform.toolchain.internal.gcc.version.GccVersionResult;
import org.gradle.process.internal.DefaultExecAction;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;

public class CompilerMetaDataProviderFactory {
    private final CachingCompilerMetaDataProvider gcc;
    private final CachingCompilerMetaDataProvider clang;

    public CompilerMetaDataProviderFactory(final FileLookup fileLookup) {
        ExecActionFactory factory = new ExecActionFactory(){

            public ExecAction newExecAction() {
                return new DefaultExecAction(fileLookup.getFileResolver());
            }
        };
        this.gcc = new CachingCompilerMetaDataProvider(GccVersionDeterminer.forGcc(factory));
        this.clang = new CachingCompilerMetaDataProvider(GccVersionDeterminer.forClang(factory));
    }

    public CompilerMetaDataProvider gcc() {
        return this.gcc;
    }

    public CompilerMetaDataProvider clang() {
        return this.clang;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Key {
        final File gccBinary;
        final List<String> args;

        private Key(File gccBinary, List<String> args) {
            this.gccBinary = gccBinary;
            this.args = args;
        }

        public boolean equals(Object obj) {
            Key other = (Key)obj;
            return other.gccBinary.equals(this.gccBinary) && other.args.equals(this.args);
        }

        public int hashCode() {
            return this.gccBinary.hashCode() ^ this.args.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachingCompilerMetaDataProvider
    implements CompilerMetaDataProvider {
        private final CompilerMetaDataProvider delegate;
        private final Map<Key, GccVersionResult> resultMap = new HashMap<Key, GccVersionResult>();

        private CachingCompilerMetaDataProvider(CompilerMetaDataProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public GccVersionResult getGccMetaData(File gccBinary, List<String> additionalArgs) {
            Key key = new Key(gccBinary, additionalArgs);
            GccVersionResult result = this.resultMap.get(key);
            if (result == null) {
                result = this.delegate.getGccMetaData(gccBinary, additionalArgs);
                this.resultMap.put(key, result);
            }
            return result;
        }
    }
}

