/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.operations.BuildOperationProcessor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.VisualCpp;
import org.gradle.nativeplatform.toolchain.VisualCppPlatformToolChain;
import org.gradle.nativeplatform.toolchain.internal.ExtendableToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.UnavailablePlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.DefaultVisualCppPlatformToolChain;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppPlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualStudioLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdk;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdkLocator;
import org.gradle.platform.base.internal.toolchain.ToolChainAvailability;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;
import org.gradle.process.internal.ExecActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualCppToolChain
extends ExtendableToolChain<VisualCppPlatformToolChain>
implements VisualCpp,
NativeToolChainInternal {
    private final String name;
    private final OperatingSystem operatingSystem;
    private final FileResolver fileResolver;
    protected static final Logger LOGGER = LoggerFactory.getLogger(VisualCppToolChain.class);
    public static final String DEFAULT_NAME = "visualCpp";
    private final ExecActionFactory execActionFactory;
    private final VisualStudioLocator visualStudioLocator;
    private final WindowsSdkLocator windowsSdkLocator;
    private final Instantiator instantiator;
    private File installDir;
    private File windowsSdkDir;
    private VisualCppInstall visualCpp;
    private WindowsSdk windowsSdk;
    private ToolChainAvailability availability;

    public VisualCppToolChain(String name, BuildOperationProcessor buildOperationProcessor, OperatingSystem operatingSystem, FileResolver fileResolver, ExecActionFactory execActionFactory, VisualStudioLocator visualStudioLocator, WindowsSdkLocator windowsSdkLocator, Instantiator instantiator) {
        super(name, buildOperationProcessor, operatingSystem, (PathToFileResolver)fileResolver);
        this.name = name;
        this.operatingSystem = operatingSystem;
        this.fileResolver = fileResolver;
        this.execActionFactory = execActionFactory;
        this.visualStudioLocator = visualStudioLocator;
        this.windowsSdkLocator = windowsSdkLocator;
        this.instantiator = instantiator;
    }

    @Override
    protected String getTypeName() {
        return "Visual Studio";
    }

    @Override
    public File getInstallDir() {
        return this.installDir;
    }

    @Override
    public void setInstallDir(Object installDirPath) {
        this.installDir = this.resolve(installDirPath);
    }

    @Override
    public File getWindowsSdkDir() {
        return this.windowsSdkDir;
    }

    @Override
    public void setWindowsSdkDir(Object windowsSdkDirPath) {
        this.windowsSdkDir = this.resolve(windowsSdkDirPath);
    }

    @Override
    public PlatformToolProvider select(NativePlatformInternal targetPlatform) {
        ToolChainAvailability result = new ToolChainAvailability();
        result.mustBeAvailable((ToolSearchResult)this.getAvailability());
        if (this.visualCpp != null && !this.visualCpp.isSupportedPlatform(targetPlatform)) {
            result.unavailable(String.format("Don't know how to build for platform '%s'.", targetPlatform.getName()));
        }
        if (!result.isAvailable()) {
            return new UnavailablePlatformToolProvider(targetPlatform.getOperatingSystem(), (ToolSearchResult)result);
        }
        DefaultVisualCppPlatformToolChain configurableToolChain = (DefaultVisualCppPlatformToolChain)this.instantiator.newInstance(DefaultVisualCppPlatformToolChain.class, new Object[]{targetPlatform, this.instantiator});
        this.configureActions.execute((Object)configurableToolChain);
        return new VisualCppPlatformToolProvider(this.buildOperationProcessor, targetPlatform.getOperatingSystem(), configurableToolChain.tools, this.visualCpp, this.windowsSdk, targetPlatform, this.execActionFactory);
    }

    private ToolChainAvailability getAvailability() {
        if (this.availability == null) {
            this.availability = new ToolChainAvailability();
            this.checkAvailable(this.availability);
        }
        return this.availability;
    }

    private void checkAvailable(ToolChainAvailability availability) {
        if (!this.operatingSystem.isWindows()) {
            availability.unavailable("Visual Studio is not available on this operating system.");
            return;
        }
        VisualStudioLocator.SearchResult visualStudioSearchResult = this.visualStudioLocator.locateVisualStudioInstalls(this.installDir);
        availability.mustBeAvailable((ToolSearchResult)visualStudioSearchResult);
        if (visualStudioSearchResult.isAvailable()) {
            this.visualCpp = visualStudioSearchResult.getVisualStudio().getVisualCpp();
        }
        WindowsSdkLocator.SearchResult windowsSdkSearchResult = this.windowsSdkLocator.locateWindowsSdks(this.windowsSdkDir);
        availability.mustBeAvailable((ToolSearchResult)windowsSdkSearchResult);
        if (windowsSdkSearchResult.isAvailable()) {
            this.windowsSdk = windowsSdkSearchResult.getSdk();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return String.format("Tool chain '%s' (%s)", this.getName(), this.getTypeName());
    }
}

