/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreferenceListener;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreferencesPanel;
import org.openstreetmap.josm.tools.I18n;

public final class ProxyPreference
implements SubPreferenceSetting {
    private static Set<ProxyPreferenceListener> listeners = new HashSet<ProxyPreferenceListener>();
    private ProxyPreferencesPanel pnlProxyPreferences;

    private ProxyPreference() {
    }

    @Override
    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        this.pnlProxyPreferences = new ProxyPreferencesPanel();
        preferenceTabbedPane.getServerPreference().addSubTab(this, I18n.tr("Proxy settings", new Object[0]), this.pnlProxyPreferences.getVerticalScrollPane(), I18n.tr("Configure whether to use a proxy server", new Object[0]));
    }

    @Override
    public boolean ok() {
        this.pnlProxyPreferences.saveToPreferences();
        for (ProxyPreferenceListener proxyPreferenceListener : listeners) {
            proxyPreferenceListener.proxyPreferenceChanged();
        }
        return false;
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane preferenceTabbedPane) {
        return preferenceTabbedPane.getServerPreference();
    }

    public static boolean addProxyPreferenceListener(ProxyPreferenceListener proxyPreferenceListener) {
        if (proxyPreferenceListener != null) {
            return listeners.add(proxyPreferenceListener);
        }
        return false;
    }

    public static boolean removeProxyPreferenceListener(ProxyPreferenceListener proxyPreferenceListener) {
        if (proxyPreferenceListener != null) {
            return listeners.remove(proxyPreferenceListener);
        }
        return false;
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ProxyPreference();
        }
    }
}

