/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.methods.DeclarationContext;
import org.jruby.truffle.nodes.methods.GetDefaultDefineeNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;

public class MethodDefinitionNode
extends RubyNode {
    private final String name;
    private final SharedMethodInfo sharedMethodInfo;
    private final CallTarget callTarget;
    @Node.Child
    private GetDefaultDefineeNode getDefaultDefineeNode;

    public MethodDefinitionNode(RubyContext context, SourceSection sourceSection, String name, SharedMethodInfo sharedMethodInfo, CallTarget callTarget) {
        super(context, sourceSection);
        this.name = name;
        this.sharedMethodInfo = sharedMethodInfo;
        this.callTarget = callTarget;
    }

    public InternalMethod executeMethod(VirtualFrame frame) {
        DynamicObject capturedDefaultDefinee;
        DynamicObject dummyModule = this.getContext().getCoreLibrary().getObjectClass();
        Visibility dummyVisibility = Visibility.PUBLIC;
        if (RubyArguments.getDeclarationContext(frame.getArguments()) == DeclarationContext.INSTANCE_EVAL) {
            if (this.getDefaultDefineeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.getDefaultDefineeNode = this.insert(new GetDefaultDefineeNode(this.getContext(), this.getSourceSection()));
            }
            capturedDefaultDefinee = this.getDefaultDefineeNode.execute(frame);
        } else {
            capturedDefaultDefinee = null;
        }
        return new InternalMethod(this.sharedMethodInfo, this.name, dummyModule, dummyVisibility, false, null, this.callTarget, null, capturedDefaultDefinee);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeMethod(frame);
    }
}

