/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.log;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.support.io.FileType;
import org.pdfsam.support.io.ObjectCollectionWriter;
import org.pdfsam.ui.io.FileChoosers;
import org.pdfsam.ui.io.RememberingLatestFileChooserWrapper;
import org.pdfsam.ui.log.LogAreaVisiblityChangedEvent;
import org.pdfsam.ui.log.LogListView;
import org.pdfsam.ui.log.LogMessage;
import org.pdfsam.ui.support.Style;
import org.sejda.eventstudio.StaticStudio;

@Named
public class LogPane
extends BorderPane {
    private LogListView logView;

    @Inject
    public LogPane(LogListView view) {
        this.logView = view;
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.setCenter((Node)this.logView);
        I18nContext i18n = DefaultI18nContext.getInstance();
        MenuItem copyItem = new MenuItem(i18n.i18n("Copy"));
        copyItem.setId("copyLogMenuItem");
        copyItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        copyItem.setOnAction(e -> this.copyLog((Collection<LogMessage>)this.logView.getSelectionModel().getSelectedItems()));
        copyItem.disableProperty().bind((ObservableValue)new BooleanBinding(){
            {
                this.bind(new Observable[]{LogPane.this.logView.getSelectionModel().getSelectedIndices()});
            }

            protected boolean computeValue() {
                return LogPane.this.logView.getSelectionModel().getSelectedItems().isEmpty();
            }
        });
        MenuItem clearItem = new MenuItem(i18n.i18n("Clear"));
        clearItem.setId("clearLogMenuItem");
        clearItem.setOnAction(e -> this.logView.getItems().clear());
        clearItem.disableProperty().bind((ObservableValue)new BooleanBinding(){
            {
                this.bind(new Observable[]{LogPane.this.logView.getItems()});
            }

            protected boolean computeValue() {
                return LogPane.this.logView.getItems().isEmpty();
            }
        });
        MenuItem selectAllItem = new MenuItem(i18n.i18n("Select all"));
        selectAllItem.setId("selectAllLogMenuItem");
        selectAllItem.setOnAction(e -> this.logView.getSelectionModel().selectAll());
        selectAllItem.disableProperty().bind((ObservableValue)clearItem.disableProperty());
        MenuItem saveItem = new MenuItem(i18n.i18n("Save log"));
        saveItem.setId("saveLogMenuItem");
        saveItem.setOnAction(e -> this.saveLog());
        saveItem.disableProperty().bind((ObservableValue)clearItem.disableProperty());
        SeparatorMenuItem separator = new SeparatorMenuItem();
        this.logView.setContextMenu(new ContextMenu(new MenuItem[]{copyItem, clearItem, selectAllItem, separator, saveItem}));
        this.logView.focusedProperty().addListener(o -> StaticStudio.eventStudio().broadcast(new LogAreaVisiblityChangedEvent()));
    }

    public void saveLog() {
        RememberingLatestFileChooserWrapper fileChooser = FileChoosers.getFileChooser(FileType.LOG, DefaultI18nContext.getInstance().i18n("Select where to save the log file"));
        fileChooser.setInitialFileName("PDFsam.log");
        File chosenFile = fileChooser.showDialog(this.getScene().getWindow(), RememberingLatestFileChooserWrapper.OpenType.SAVE);
        if (chosenFile != null) {
            if (chosenFile.exists()) {
                // empty if block
            }
            ObjectCollectionWriter.writeContent((Collection<? extends Object>)this.logView.getItems()).to(chosenFile);
        }
    }

    public void copyLog(Collection<LogMessage> selected) {
        if (!selected.isEmpty()) {
            ClipboardContent content = new ClipboardContent();
            ObjectCollectionWriter.writeContent(selected).to(content);
            Clipboard.getSystemClipboard().setContent((Map)content);
        }
    }
}

