/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import org.sejda.common.ComponentsUtility;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.split.PagesPdfSplitter;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.AbstractSplitByPageParameters;
import org.sejda.model.parameter.base.SinglePdfSourceMultipleOutputParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.sambox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitByPageNumbersTask<T extends AbstractSplitByPageParameters>
extends BaseTask<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SplitByPageNumbersTask.class);
    private PDDocument document = null;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;
    private PagesPdfSplitter<T> splitter;

    @Override
    public void before(T parameters) {
        this.documentLoader = new DefaultPdfSourceOpener();
    }

    @Override
    public void execute(T parameters) throws TaskException {
        LOG.debug("Opening {} ", (Object)((SinglePdfSourceMultipleOutputParameters)parameters).getSource());
        this.document = ((SinglePdfSourceMultipleOutputParameters)parameters).getSource().open(this.documentLoader).getUnderlyingPDDocument();
        this.splitter = new PagesPdfSplitter<T>(this.document, parameters);
        LOG.debug("Starting split by page numbers for {} ", (Object)parameters);
        this.splitter.split(this.getNotifiableTaskMetadata());
        LOG.debug("Input documents split and written to {}", (Object)((SinglePdfSourceMultipleOutputParameters)parameters).getOutput());
    }

    @Override
    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.document);
        this.splitter = null;
    }
}

