/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import org.sejda.common.ComponentsUtility;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.split.AbstractPdfSplitter;
import org.sejda.impl.sambox.component.split.SizePdfSplitter;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.SplitBySizeParameters;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.task.BaseTask;
import org.sejda.sambox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitBySizeTask
extends BaseTask<SplitBySizeParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(SplitBySizeTask.class);
    private PdfSourceOpener<PDDocumentHandler> documentLoader;
    private PDDocumentHandler sourceDocumentHandler;
    private AbstractPdfSplitter<SplitBySizeParameters> splitter;

    @Override
    public void before(SplitBySizeParameters parameters) {
        this.documentLoader = new DefaultPdfSourceOpener();
    }

    @Override
    public void execute(SplitBySizeParameters parameters) throws TaskException {
        PdfSource source = parameters.getSource();
        LOG.debug("Opening {}", (Object)source);
        this.sourceDocumentHandler = source.open(this.documentLoader);
        this.sourceDocumentHandler.getPermissions().ensurePermission(PdfAccessPermission.ASSEMBLE);
        PDDocument sourceDocument = this.sourceDocumentHandler.getUnderlyingPDDocument();
        this.splitter = new SizePdfSplitter(sourceDocument, parameters);
        LOG.debug("Starting split by size {} bytes", (Object)parameters.getSizeToSplitAt());
        this.splitter.split(this.getNotifiableTaskMetadata());
        LOG.debug("Input documents split and written to {}", (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        this.closeResource();
    }

    private void closeResource() {
        ComponentsUtility.nullSafeCloseQuietly(this.sourceDocumentHandler);
        this.splitter = null;
    }
}

