/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.output;

import java.io.Closeable;
import java.io.IOException;
import org.sejda.io.CountingWritableByteChannel;
import org.sejda.sambox.cos.COSDocument;
import org.sejda.sambox.output.AbstractPDFBodyWriter;
import org.sejda.sambox.output.AsyncPDFBodyWriter;
import org.sejda.sambox.output.DefaultPDFWriter;
import org.sejda.sambox.output.IndirectObjectsWriter;
import org.sejda.sambox.output.ObjectsStreamPDFBodyWriter;
import org.sejda.sambox.output.PDFWriteContext;
import org.sejda.sambox.output.SyncPDFBodyWriter;
import org.sejda.sambox.output.WriteOption;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.util.IOUtils;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDDocumentWriter
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PDDocumentWriter.class);
    private DefaultPDFWriter writer;
    private PDFWriteContext context;

    public PDDocumentWriter(CountingWritableByteChannel channel, WriteOption ... options) {
        RequireUtils.requireNotNullArg(channel, "Cannot write to a null channel");
        this.context = new PDFWriteContext(options);
        this.writer = new DefaultPDFWriter(new IndirectObjectsWriter(channel, this.context));
    }

    public void write(PDDocument document) throws IOException {
        RequireUtils.requireNotNullArg(document, "PDDocument cannot be null");
        if (this.context.hasWriteOption(WriteOption.XREF_STREAM) || this.context.hasWriteOption(WriteOption.OBJECT_STREAMS)) {
            document.requireMinVersion("1.5");
        }
        if (document.getEncryption() != null) {
            LOG.warn("Encryption is not supported yet, the document will be written decrypted");
        }
        this.writer.writeHeader(document.getDocument().getHeaderVersion());
        this.writeBody(document.getDocument());
        this.writeXref(document);
    }

    private void writeBody(COSDocument document) throws IOException {
        try (AbstractPDFBodyWriter bodyWriter = this.objectStreamWriter(this.bodyWriter());){
            LOG.debug("Writing body using " + bodyWriter.getClass());
            bodyWriter.write(document);
        }
    }

    private AbstractPDFBodyWriter bodyWriter() {
        if (this.context.hasWriteOption(WriteOption.SYNC_BODY_WRITE)) {
            return new SyncPDFBodyWriter(this.writer.writer(), this.context);
        }
        return new AsyncPDFBodyWriter(this.writer.writer(), this.context);
    }

    private AbstractPDFBodyWriter objectStreamWriter(AbstractPDFBodyWriter wrapped) {
        if (this.context.hasWriteOption(WriteOption.OBJECT_STREAMS)) {
            return new ObjectsStreamPDFBodyWriter(wrapped);
        }
        return wrapped;
    }

    private void writeXref(PDDocument document) throws IOException {
        if (this.context.hasWriteOption(WriteOption.XREF_STREAM) || this.context.hasWriteOption(WriteOption.OBJECT_STREAMS)) {
            this.writer.writeXrefStream(document.getDocument().getTrailer());
        } else {
            long startxref = this.writer.writeXrefTable();
            this.writer.writeTrailer(document.getDocument().getTrailer(), startxref);
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.writer);
    }
}

