/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangeNodesCommand
extends Command {
    private final Way way;
    private final List<Node> newNodes;

    public ChangeNodesCommand(Way way, List<Node> list) {
        this.way = way;
        this.newNodes = list;
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.way.setNodes(this.newNodes);
        this.way.setModified(true);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.way);
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Changed nodes of {0}", this.way.getDisplayName(DefaultNameFormatter.getInstance()));
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get(OsmPrimitiveType.WAY);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.newNodes == null ? 0 : this.newNodes.hashCode());
        n = 31 * n + (this.way == null ? 0 : this.way.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChangeNodesCommand changeNodesCommand = (ChangeNodesCommand)object;
        if (this.newNodes == null ? changeNodesCommand.newNodes != null : !this.newNodes.equals(changeNodesCommand.newNodes)) {
            return false;
        }
        return !(this.way == null ? changeNodesCommand.way != null : !this.way.equals(changeNodesCommand.way));
    }
}

