/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.ext;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Set;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.object.ObjectGraph;

@CoreClass(name="Truffle::ObjSpace")
public abstract class ObjSpaceNodes {

    @CoreMethod(names={"trace_allocations_stop"}, isModuleFunction=true)
    public static abstract class TraceAllocationsStopNode
    extends CoreMethodArrayArgumentsNode {
        public TraceAllocationsStopNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject traceAllocationsStop() {
            this.getContext().getObjectSpaceManager().traceAllocationsStop();
            return this.nil();
        }
    }

    @CoreMethod(names={"trace_allocations_start"}, isModuleFunction=true)
    public static abstract class TraceAllocationsStartNode
    extends CoreMethodArrayArgumentsNode {
        public TraceAllocationsStartNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject traceAllocationsStart() {
            this.getContext().getObjectSpaceManager().traceAllocationsStart();
            return this.nil();
        }
    }

    @CoreMethod(names={"root_objects"}, isModuleFunction=true)
    public static abstract class RootObjectsNode
    extends CoreMethodArrayArgumentsNode {
        public RootObjectsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject rootObjects() {
            Set<DynamicObject> objects = ObjectGraph.stopAndGetRootObjects(this, this.getContext());
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects.toArray(), objects.size());
        }
    }

    @CoreMethod(names={"adjacent_objects"}, isModuleFunction=true, required=1)
    public static abstract class AdjacentObjectsNode
    extends CoreMethodArrayArgumentsNode {
        public AdjacentObjectsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject adjacentObjects(DynamicObject object) {
            Set<DynamicObject> objects = ObjectGraph.getAdjacentObjects(object);
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects.toArray(), objects.size());
        }
    }

    @CoreMethod(names={"memsize_of"}, isModuleFunction=true, required=1)
    public static abstract class MemsizeOfNode
    extends CoreMethodArrayArgumentsNode {
        public MemsizeOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNil(nil)"})
        public int memsizeOf(Object nil) {
            return 0;
        }

        @Specialization
        public int memsizeOf(boolean object) {
            return 0;
        }

        @Specialization
        public int memsizeOf(int object) {
            return 0;
        }

        @Specialization
        public int memsizeOf(long object) {
            return 0;
        }

        @Specialization
        public int memsizeOf(double object) {
            return 0;
        }

        @Specialization(guards={"isRubyArray(object)"})
        public int memsizeOfArray(DynamicObject object) {
            return 1 + object.getShape().getPropertyListInternal(false).size() + Layouts.ARRAY.getSize(object);
        }

        @Specialization(guards={"isRubyHash(object)"})
        public int memsizeOfHash(DynamicObject object) {
            return 1 + object.getShape().getPropertyListInternal(false).size() + Layouts.HASH.getSize(object);
        }

        @Specialization(guards={"isRubyString(object)"})
        public int memsizeOfString(DynamicObject object) {
            return 1 + object.getShape().getPropertyListInternal(false).size() + StringOperations.getByteList(object).getRealSize();
        }

        @Specialization(guards={"isRubyMatchData(object)"})
        public int memsizeOfMatchData(DynamicObject object) {
            return 1 + object.getShape().getPropertyListInternal(false).size() + Layouts.MATCH_DATA.getValues(object).length;
        }

        @Specialization(guards={"!isNil(object)", "!isRubyArray(object)", "!isRubyHash(object)", "!isRubyString(object)", "!isRubyMatchData(object)"})
        public int memsizeOfObject(DynamicObject object) {
            return 1 + object.getShape().getPropertyListInternal(false).size();
        }
    }
}

