/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.support.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import javafx.scene.input.ClipboardContent;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.support.io.OngoingWrite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectCollectionWriter
implements OngoingWrite {
    public static final String SEPARATOR = System.getProperty("line.separator", "\n");
    private static final Logger LOG = LoggerFactory.getLogger(ObjectCollectionWriter.class);
    private Collection<? extends Object> content;

    private ObjectCollectionWriter(Collection<? extends Object> content) {
        this.content = content;
    }

    public static OngoingWrite writeContent(Collection<? extends Object> content) {
        return new ObjectCollectionWriter(content);
    }

    @Override
    public void to(File file) {
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);){
            for (Object object : this.content) {
                writer.append(this.defaultLineSeparator(object.toString()));
            }
        }
        catch (Exception e) {
            LOG.error(DefaultI18nContext.getInstance().i18n("Error saving log file."), e);
        }
        LOG.info(DefaultI18nContext.getInstance().i18n("File {0} saved.", file.getAbsolutePath()));
    }

    @Override
    public void to(ClipboardContent clipboard) {
        try (StringWriter writer = new StringWriter();){
            for (Object object : this.content) {
                writer.append(this.defaultLineSeparator(object.toString()));
            }
            clipboard.putString(writer.toString());
        }
        catch (Exception e) {
            LOG.error(DefaultI18nContext.getInstance().i18n("Error saving log file."), e);
        }
    }

    private String defaultLineSeparator(String line) {
        return StringUtils.trimToEmpty(line).concat(SEPARATOR);
    }
}

