/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.output;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.output.PDFWriteContext;
import org.sejda.sambox.xref.XrefEntry;

class XrefStream
extends COSStream {
    XrefStream(COSDictionary dictionary, PDFWriteContext context) throws IOException {
        super(dictionary);
        this.removeItem(COSName.PREV);
        this.removeItem(COSName.XREF_STM);
        this.removeItem(COSName.DOC_CHECKSUM);
        this.removeItem(COSName.DECODE_PARMS);
        this.removeItem(COSName.FILTER);
        this.removeItem(COSName.F_DECODE_PARMS);
        this.removeItem(COSName.F_FILTER);
        this.removeItem(COSName.F);
        this.removeItem(COSName.LENGTH);
        this.removeItem(COSName.ENCRYPT);
        this.setName(COSName.TYPE, COSName.XREF.getName());
        this.setLong(COSName.SIZE, context.highestWritten().getObjectNumber() + 1L);
        this.setItem(COSName.INDEX, (COSBase)new COSArray(COSInteger.get(context.lowestWritten().getObjectNumber()), COSInteger.get(context.highestWritten().getObjectNumber() - context.lowestWritten().getObjectNumber() + 1L)));
        int secondFieldLength = XrefStream.sizeOf(context.highestWritten().getByteOffset());
        this.setItem(COSName.W, (COSBase)new COSArray(COSInteger.get(1L), COSInteger.get(secondFieldLength), COSInteger.get(2L)));
        try (OutputStream out = this.createUnfilteredStream();){
            for (long key = context.lowestWritten().getObjectNumber(); key <= context.highestWritten().getObjectNumber(); ++key) {
                out.write(Optional.ofNullable(context.getWritten(key)).orElse(XrefEntry.freeEntry(key, 0)).toXrefStreamEntry(secondFieldLength, 2));
            }
        }
        this.setLong(COSName.DL, this.getUnfilteredLength());
        this.addCompression();
    }

    private static int sizeOf(long number) {
        int size = 0;
        while (number > 0L) {
            ++size;
            number >>= 8;
        }
        return size;
    }
}

