/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.sejda.io.CountingWritableByteChannel;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSDocument;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.cos.DirectCOSObject;
import org.sejda.sambox.output.PDDocumentWriter;
import org.sejda.sambox.output.WriteOption;
import org.sejda.sambox.pdmodel.DefaultResourceCache;
import org.sejda.sambox.pdmodel.PDDocumentCatalog;
import org.sejda.sambox.pdmodel.PDDocumentInformation;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageTree;
import org.sejda.sambox.pdmodel.ResourceCache;
import org.sejda.sambox.pdmodel.common.PDStream;
import org.sejda.sambox.pdmodel.encryption.AccessPermission;
import org.sejda.sambox.pdmodel.encryption.PDEncryption;
import org.sejda.sambox.pdmodel.encryption.ProtectionPolicy;
import org.sejda.sambox.pdmodel.encryption.SecurityHandler;
import org.sejda.sambox.pdmodel.encryption.SecurityHandlerFactory;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.util.Charsets;
import org.sejda.sambox.util.SpecVersionUtils;
import org.sejda.sambox.util.Version;
import org.sejda.util.IOUtils;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDDocument
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PDDocument.class);
    private final COSDocument document;
    private PDDocumentCatalog documentCatalog;
    private PDEncryption encryption;
    private AccessPermission accessPermission;
    private boolean open = true;
    private OnClose onClose;
    private ResourceCache resourceCache = new DefaultResourceCache();
    private final Set<PDFont> fontsToSubset = new HashSet<PDFont>();

    public PDDocument() {
        this.document = new COSDocument();
        this.document.getCatalog().setItem(COSName.VERSION, (COSBase)COSName.getPDFName("1.4"));
        COSDictionary pages = new COSDictionary();
        this.document.getCatalog().setItem(COSName.PAGES, (COSBase)pages);
        pages.setItem(COSName.TYPE, (COSBase)COSName.PAGES);
        COSArray kidsArray = new COSArray();
        pages.setItem(COSName.KIDS, (COSBase)kidsArray);
        pages.setItem(COSName.COUNT, (COSBase)COSInteger.ZERO);
    }

    public PDDocument(COSDocument doc) {
        this(doc, null);
    }

    public PDDocument(COSDocument doc, AccessPermission permission) {
        this.document = doc;
        this.accessPermission = permission;
    }

    public void addPage(PDPage page) {
        this.requireOpen();
        this.getPages().add(page);
    }

    public void removePage(PDPage page) {
        this.requireOpen();
        this.getPages().remove(page);
    }

    public void removePage(int pageNumber) {
        this.requireOpen();
        this.getPages().remove(pageNumber);
    }

    public PDPage importPage(PDPage page) {
        this.requireOpen();
        PDPage importedPage = new PDPage(page.getCOSObject().duplicate());
        InputStream in = null;
        try {
            in = page.getContents();
            if (in != null) {
                PDStream dest = new PDStream(page.getContents(), COSName.FLATE_DECODE);
                importedPage.setContents(dest);
            }
            this.addPage(importedPage);
        }
        catch (IOException e) {
            IOUtils.closeQuietly(in);
        }
        return importedPage;
    }

    public COSDocument getDocument() {
        return this.document;
    }

    public PDDocumentInformation getDocumentInformation() {
        COSDictionary infoDic = (COSDictionary)this.document.getTrailer().getDictionaryObject(COSName.INFO);
        if (infoDic == null) {
            infoDic = new COSDictionary();
            this.document.getTrailer().setItem(COSName.INFO, (COSBase)infoDic);
        }
        return new PDDocumentInformation(infoDic);
    }

    public void setDocumentInformation(PDDocumentInformation documentInformation) {
        this.requireOpen();
        this.document.getTrailer().setItem(COSName.INFO, (COSBase)documentInformation.getCOSObject());
    }

    public PDDocumentCatalog getDocumentCatalog() {
        if (this.documentCatalog == null) {
            this.documentCatalog = new PDDocumentCatalog(this, this.document.getCatalog());
        }
        return this.documentCatalog;
    }

    public boolean isEncrypted() {
        return this.document.isEncrypted();
    }

    public PDEncryption getEncryption() {
        if (this.encryption == null && this.isEncrypted()) {
            this.encryption = new PDEncryption(this.document.getEncryptionDictionary());
        }
        return this.encryption;
    }

    public void setEncryption(PDEncryption encryption) {
        this.requireOpen();
        this.encryption = encryption;
    }

    public void removeEncryption() {
        this.requireOpen();
        this.encryption = null;
        this.getDocument().getTrailer().removeItem(COSName.ENCRYPT);
    }

    Set<PDFont> getFontsToSubset() {
        return this.fontsToSubset;
    }

    public PDPage getPage(int pageIndex) {
        return this.getDocumentCatalog().getPages().get(pageIndex);
    }

    public PDPageTree getPages() {
        return this.getDocumentCatalog().getPages();
    }

    public int getNumberOfPages() {
        return this.getDocumentCatalog().getPages().getCount();
    }

    public void protect(ProtectionPolicy policy) throws IOException {
        SecurityHandler securityHandler;
        this.requireOpen();
        if (!this.isEncrypted()) {
            this.encryption = new PDEncryption();
        }
        if ((securityHandler = SecurityHandlerFactory.INSTANCE.newSecurityHandlerForPolicy(policy)) == null) {
            throw new IOException("No security handler for policy " + policy);
        }
        this.getEncryption().setSecurityHandler(securityHandler);
    }

    public AccessPermission getCurrentAccessPermission() {
        if (this.accessPermission == null) {
            this.accessPermission = AccessPermission.getOwnerAccessPermission();
        }
        return this.accessPermission;
    }

    public String getVersion() {
        String headerVersion = this.getDocument().getHeaderVersion();
        if (SpecVersionUtils.isAtLeast(headerVersion, "1.4")) {
            return Optional.ofNullable(this.getDocumentCatalog().getVersion()).filter(catalogVersion -> catalogVersion.compareTo(headerVersion) > 0).orElse(headerVersion);
        }
        return headerVersion;
    }

    public void setVersion(String newVersion) {
        this.requireOpen();
        RequireUtils.requireNotBlank(newVersion, "Spec version cannot be blank");
        int compare = this.getVersion().compareTo(newVersion);
        if (compare > 0) {
            LOG.warn("Spec version downgrade not allowed");
        } else if (compare < 0) {
            if (SpecVersionUtils.isAtLeast(newVersion, "1.4")) {
                this.getDocumentCatalog().setVersion(newVersion);
            }
            this.getDocument().setHeaderVersion(newVersion);
        }
    }

    public void requireMinVersion(String version) {
        if (!SpecVersionUtils.isAtLeast(this.getVersion(), version)) {
            this.setVersion(version);
        }
    }

    public void setOnCloseAction(OnClose onClose) {
        this.requireOpen();
        this.onClose = onClose;
    }

    private void requireOpen() throws IllegalStateException {
        if (!this.isOpen()) {
            throw new IllegalStateException("The document is closed");
        }
    }

    private void generateFileIdentifier() {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(Long.toString(System.currentTimeMillis()).getBytes(Charsets.ISO_8859_1));
            Optional.ofNullable(this.getDocument().getTrailer().getDictionaryObject(COSName.INFO)).map(d -> (COSDictionary)d).ifPresent(d -> {
                for (COSBase current : d.getValues()) {
                    md5.update(current.toString().getBytes(Charsets.ISO_8859_1));
                }
            });
            COSString retVal = COSString.newInstance(md5.digest());
            retVal.setForceHexForm(true);
            DirectCOSObject id = DirectCOSObject.asDirectObject(retVal);
            this.getDocument().getTrailer().setItem(COSName.ID, (COSBase)DirectCOSObject.asDirectObject(new COSArray(id, id)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeTo(File file, WriteOption ... options) throws IOException {
        this.writeTo(CountingWritableByteChannel.from(file), options);
    }

    public void writeTo(String filename, WriteOption ... options) throws IOException {
        this.writeTo(CountingWritableByteChannel.from(filename), options);
    }

    public void writeTo(WritableByteChannel channel, WriteOption ... options) throws IOException {
        this.writeTo(CountingWritableByteChannel.from(channel), options);
    }

    public void writeTo(OutputStream out, WriteOption ... options) throws IOException {
        this.writeTo(CountingWritableByteChannel.from(out), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTo(CountingWritableByteChannel output, WriteOption ... options) throws IOException {
        this.requireOpen();
        this.getDocumentInformation().setProducer("SAMBox " + Version.getVersion() + " (www.sejda.org)");
        this.getDocumentInformation().setModificationDate(Calendar.getInstance());
        for (PDFont font : this.fontsToSubset) {
            font.subset();
        }
        this.fontsToSubset.clear();
        this.generateFileIdentifier();
        try (PDDocumentWriter writer = new PDDocumentWriter(output, options);){
            writer.write(this);
        }
        finally {
            IOUtils.close(this);
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        if (this.onClose != null) {
            this.onClose.onClose();
        }
        this.resourceCache.clear();
        this.open = false;
    }

    public ResourceCache getResourceCache() {
        return this.resourceCache;
    }

    @FunctionalInterface
    public static interface OnClose {
        public void onClose() throws IOException;
    }
}

