#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: statistics
version: 0.13.2.3
id: statistics-0.13.2.3-d6ed6ed84339731797ff8544ac5c55da
key: stati_3ZZ8y45xeKcLi5IxoNZCFq
license: BSD3
copyright: 2009-2014 Bryan O'\''Sullivan
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
homepage: https://github.com/bos/statistics
synopsis: A library of statistical types, data, and functions
description:
    This library provides a number of common functions and types useful
    in statistics.  We focus on high performance, numerical robustness,
    and use of good algorithms.  Where possible, we provide
    references to the statistical literature.
    .
    The library'\''s facilities can be divided into four broad categories:
    .
    * Working with widely used discrete and continuous probability
    distributions.  (There are dozens of exotic distributions in use;
    we focus on the most common.)
    .
    * Computing with sample data: quantile estimation, kernel density
    estimation, histograms, bootstrap methods, significance testing,
    and regression and autocorrelation analysis.
    .
    * Random variate generation under several different distributions.
    .
    * Common statistical tests for significant differences between
    samples.
category: Math, Statistics
author: Bryan O'\''Sullivan <bos@serpentine.com>
exposed: True
exposed-modules:
    Statistics.Autocorrelation Statistics.Constants
    Statistics.Correlation.Kendall Statistics.Distribution
    Statistics.Distribution.Beta Statistics.Distribution.Binomial
    Statistics.Distribution.CauchyLorentz
    Statistics.Distribution.ChiSquared
    Statistics.Distribution.Exponential
    Statistics.Distribution.FDistribution Statistics.Distribution.Gamma
    Statistics.Distribution.Geometric
    Statistics.Distribution.Hypergeometric
    Statistics.Distribution.Normal Statistics.Distribution.Poisson
    Statistics.Distribution.StudentT Statistics.Distribution.Transform
    Statistics.Distribution.Uniform Statistics.Function
    Statistics.Math.RootFinding Statistics.Matrix
    Statistics.Matrix.Algorithms Statistics.Matrix.Mutable
    Statistics.Matrix.Types Statistics.Quantile Statistics.Regression
    Statistics.Resampling Statistics.Resampling.Bootstrap
    Statistics.Sample Statistics.Sample.Histogram
    Statistics.Sample.KernelDensity
    Statistics.Sample.KernelDensity.Simple Statistics.Sample.Powers
    Statistics.Test.ChiSquared Statistics.Test.KolmogorovSmirnov
    Statistics.Test.KruskalWallis Statistics.Test.MannWhitneyU
    Statistics.Test.Types Statistics.Test.WilcoxonT
    Statistics.Transform Statistics.Types
hidden-modules: Statistics.Distribution.Poisson.Internal
                Statistics.Function.Comparison Statistics.Internal
                Statistics.Sample.Internal Statistics.Test.Internal
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/statistics-0.13.2.3
library-dirs: /usr/lib/ghc-7.10.3/site-local/statistics-0.13.2.3
data-dir: /usr/share/arm-linux-ghc-7.10.3/statistics-0.13.2.3
hs-libraries: HSstatistics-0.13.2.3-3ZZ8y45xeKcLi5IxoNZCFq
depends:
    aeson-0.10.0.0-3aa334e096178e3f732c7fe0cfda35e7
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    binary-0.7.5.0-29f7044fa0b12dc5c2dcec897db5c464
    deepseq-1.4.1.1-3975618f889b45239daa47b7443eaeee
    erf-2.0.0.0-aab48415b057e47fae23d9f8b194cc70
    math-functions-0.1.5.2-cca3e664aeca2116145d4ae702f767c6
    monad-par-0.3.4.7-775d7d36eed9307a352844e8cf65ec62
    mwc-random-0.13.3.2-98468153c4310cd751df6539413688b8
    primitive-0.6.1.0-013c88e6ffae491f11ac3b8c0552ce0e
    vector-0.11.0.0-711d35c4a6ac1ea2e529dc3ee3328963
    vector-algorithms-0.7.0.1-35e55e2e8e51824728ed456b5a330a6b
    vector-binary-instances-0.2.1.1-c0febfb5ca69d46d3d7932a3e5b87de1
haddock-interfaces: /usr/share/doc/haskell-statistics/html/statistics.haddock
haddock-html: /usr/share/doc/haskell-statistics/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
