/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.util;

import ch.softenvironment.client.ResourceManager;
import ch.softenvironment.util.Tracer;

public class DeveloperException
extends RuntimeException {
    private String title = null;
    private String origin = null;

    public DeveloperException(String message) {
        this(message, null, null, 1);
    }

    public DeveloperException(String message, String title) {
        this(message, title, null, 1);
    }

    public DeveloperException(String message, String title, Throwable cause) {
        this(message, title, cause, 1);
    }

    protected DeveloperException(String message, String title, Throwable cause, int stackTraceOffset) {
        super(message, cause);
        String msg = "";
        if (cause != null) {
            msg = "[" + ResourceManager.getResource(DeveloperException.class, "CIOriginalException") + ": " + cause.getMessage() + "]";
        }
        this.origin = Tracer.formatOrigin(Tracer.getOrigin(1));
        Tracer.getInstance().developerError("[origin: " + this.origin + "] " + message + " " + msg);
        this.title = title == null ? ResourceManager.getResource(DeveloperException.class, "CTDevelopmentError") : title;
    }

    public final String getTitle() {
        return this.title;
    }

    @Override
    public final String getLocalizedMessage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getMessage());
        buffer.append("\n" + ResourceManager.getResource(DeveloperException.class, "CISource") + ": " + this.origin);
        if (this.getCause() != null) {
            buffer.append("\n" + ResourceManager.getResource(DeveloperException.class, "CIOriginalException") + "=[" + this.getCause().getLocalizedMessage() + "]");
        }
        return buffer.toString();
    }
}

